/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiTemplate;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.internal.utils.XmlUtils;
import com.googlecode.gwt.test.uibinder.UiXmlContentHandler;
import com.googlecode.gwt.test.utils.JavassistUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiBinderParser {
    UiBinderParser() {
    }

    <T> T createUiComponent(Class<UiBinder<?, ?>> uiBinderClass, Object owner) {
        Class<?> rootComponentClass = this.getRootElementClass(uiBinderClass);
        InputStream uiXmlStream = this.getUiXmlFile(owner.getClass(), uiBinderClass);
        if (uiXmlStream == null) {
            throw new GwtTestUiBinderException("Cannot find the .ui.xml file corresponding to '" + owner.getClass().getName() + "'");
        }
        UiXmlContentHandler contentHandler = new UiXmlContentHandler(rootComponentClass, owner);
        XMLReader saxReader = XmlUtils.newXMLReader();
        try {
            saxReader.setContentHandler(contentHandler);
            saxReader.parse(new InputSource(uiXmlStream));
        }
        catch (Exception e) {
            if (GwtTestException.class.isInstance(e)) {
                throw (GwtTestException)e;
            }
            throw new GwtTestUiBinderException("Error while parsing '" + owner.getClass().getSimpleName() + ".ui.xml'", e);
        }
        finally {
            try {
                uiXmlStream.close();
            }
            catch (IOException e) {}
        }
        return (T)contentHandler.getRootComponent();
    }

    private Class<?> getRootElementClass(Class<UiBinder<?, ?>> uiBinderClass) {
        for (Type type : uiBinderClass.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getActualTypeArguments()[0];
        }
        throw new GwtTestUiBinderException("The UiBinder subinterface '" + uiBinderClass.getName() + "' is not parameterized. Please add its generic types.");
    }

    private InputStream getUiXmlFile(Class<?> ownerClass, Class<UiBinder<?, ?>> uiBinderClass) {
        String uiTemplateValue;
        InputStream is = ownerClass.getResourceAsStream(ownerClass.getSimpleName() + ".ui.xml");
        if (is == null && (uiTemplateValue = JavassistUtils.getInvisibleAnnotationStringValue(uiBinderClass, UiTemplate.class, "value")) != null) {
            is = ownerClass.getResourceAsStream(uiTemplateValue);
        }
        if (is == null && ownerClass.getSuperclass() != Object.class) {
            is = this.getUiXmlFile(ownerClass.getSuperclass(), uiBinderClass);
        }
        return is;
    }
}

