/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.uibinder.UiBinderXmlUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiBinderBeanUtils {
    private static final BeanUtilsBean UIBINDER_BEANUTILS = new BeanUtilsBean(new ConvertUtilsBean(){

        public Object convert(String value, Class clazz) {
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, value);
            }
            return super.convert(value, clazz);
        }
    }, new PropertyUtilsBean());

    public static void populateObject(Object o, Map<String, Object> properties) {
        try {
            HashMap<String, Object> filteredProperties = new HashMap<String, Object>();
            for (String key : properties.keySet()) {
                if (!PropertyUtils.isWriteable((Object)o, (String)key)) continue;
                filteredProperties.put(key, properties.get(key));
            }
            UIBINDER_BEANUTILS.populate(o, filteredProperties);
        }
        catch (Exception e) {
            throw new ReflectionException("UiBinder error while setting properties for '" + o.getClass().getSimpleName() + "'", e);
        }
        String[] styles = (String[])properties.get("addStyleNames");
        if (styles != null) {
            for (String style : styles) {
                if (o instanceof IsWidget) {
                    ((IsWidget)o).asWidget().addStyleName(style);
                    continue;
                }
                if (!(o instanceof UIObject)) continue;
                ((UIObject)o).addStyleName(style);
            }
        }
    }

    public static void registerConverter(Converter converter, Class<?> clazz) {
        UIBINDER_BEANUTILS.getConvertUtils().register(converter, clazz);
    }

    static {
        UiBinderBeanUtils.registerConverter(new Converter(){

            public Object convert(Class type, Object value) {
                return UiBinderXmlUtils.parseHorizontalAlignment(value.toString());
            }
        }, HasHorizontalAlignment.HorizontalAlignmentConstant.class);
        UiBinderBeanUtils.registerConverter(new Converter(){

            public Object convert(Class type, Object value) {
                return UiBinderXmlUtils.parseVerticalAlignment(value.toString());
            }
        }, HasVerticalAlignment.VerticalAlignmentConstant.class);
        UiBinderBeanUtils.registerConverter(new Converter(){

            public Object convert(Class type, Object value) {
                return UiBinderXmlUtils.parseTextAlignConstant(value.toString());
            }
        }, TextBoxBase.TextAlignConstant.class);
    }
}

