/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.utils;

import com.google.gwt.user.client.ui.RadioButton;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonManager
implements AfterTestCallback {
    private static RadioButtonManager INSTANCE;
    private final Map<String, Set<RadioButton>> map = new HashMap<String, Set<RadioButton>>();

    public static void beforeSetName(RadioButton rb, String newName) {
        Set<RadioButton> rbs = RadioButtonManager.get().getRadioButtons(rb);
        if (rbs == null) {
            return;
        }
        rbs.remove(rb);
        RadioButtonManager.get().registerWithNewName(rb, newName);
    }

    public static RadioButtonManager get() {
        if (INSTANCE == null) {
            INSTANCE = new RadioButtonManager();
        }
        return INSTANCE;
    }

    public static void onLoad(RadioButton rb) {
        RadioButtonManager.get().register(rb);
    }

    public static void onRadioGroupChanged(RadioButton rb, Boolean value, boolean fireEvents) {
        if (value != null && value.booleanValue()) {
            Set<RadioButton> rbs = RadioButtonManager.get().getRadioButtons(rb);
            if (rbs == null) {
                return;
            }
            for (RadioButton radioButton : rbs) {
                if (rb.equals(radioButton) || !radioButton.getValue().booleanValue()) continue;
                radioButton.setValue(Boolean.valueOf(false), fireEvents);
            }
        }
    }

    public static void onUnload(RadioButton rb) {
        RadioButtonManager.get().deregister(rb);
    }

    private RadioButtonManager() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() {
        this.map.clear();
    }

    private void deregister(RadioButton rb) {
        Set<RadioButton> rbs = this.getRadioButtons(rb);
        if (rbs != null) {
            rbs.remove(rb);
        }
    }

    private Set<RadioButton> getRadioButtons(RadioButton rb) {
        if (!rb.isAttached()) {
            return null;
        }
        return this.getRadioButtons(rb.getName());
    }

    private Set<RadioButton> getRadioButtons(String groupName) {
        Set<RadioButton> set = this.map.get(groupName);
        if (set == null) {
            set = new HashSet<RadioButton>();
            this.map.put(groupName, set);
        }
        return set;
    }

    private void register(RadioButton rb) {
        this.getRadioButtons(rb).add(rb);
    }

    private void registerWithNewName(RadioButton rb, String newName) {
        this.getRadioButtons(newName).add(rb);
    }
}

