/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.rewrite;

import com.google.gwt.dev.asm.ClassAdapter;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.FieldVisitor;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import com.googlecode.gwt.test.internal.rewrite.OverlayTypesRewriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WriteJsoImpl
extends ClassAdapter {
    private final HostedModeClassRewriter.InstanceMethodOracle mapper;
    private String originalName;

    public static ClassVisitor create(ClassVisitor cv, String classDescriptor, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper, HostedModeClassRewriter.SingleJsoImplData singleJsoImplData) {
        if (classDescriptor.equals(OverlayTypesRewriter.JAVASCRIPTOBJECT_IMPL_DESC)) {
            return new ForJsoDollar(cv, jsoDescriptors, mapper, singleJsoImplData);
        }
        return new ForJsoInterface(cv, mapper);
    }

    private WriteJsoImpl(ClassVisitor cv, HostedModeClassRewriter.InstanceMethodOracle mapper) {
        super(cv);
        this.mapper = mapper;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.originalName = name;
        super.visit(version, 4105, name + '$', signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isCtor = this.isCtor(name);
        if (!(isCtor || this.isStatic(access) || this.isObjectMethod(name + desc))) {
            access |= 8;
            desc = OverlayTypesRewriter.addSyntheticThisParam(this.getOriginalName(), desc);
            name = name + "$";
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    protected String getOriginalName() {
        return this.originalName;
    }

    protected boolean isCtor(String name) {
        return "<init>".equals(name);
    }

    protected boolean isObjectMethod(String signature) {
        return "java/lang/Object".equals(this.mapper.findOriginalDeclaringClass(this.originalName, signature));
    }

    protected boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    protected MethodVisitor visitMethodNoRewrite(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private static class ForJsoInterface
    extends WriteJsoImpl {
        public ForJsoInterface(ClassVisitor cv, HostedModeClassRewriter.InstanceMethodOracle mapper) {
            super(cv, mapper);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            superName = superName + '$';
            interfaces = null;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean isCtor = this.isCtor(name);
            if (isCtor) {
                return null;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForJsoDollar
    extends WriteJsoImpl {
        private final HostedModeClassRewriter.SingleJsoImplData jsoData;
        private final Set<String> jsoDescriptors;

        public ForJsoDollar(ClassVisitor cv, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper, HostedModeClassRewriter.SingleJsoImplData jsoData) {
            super(cv, mapper);
            this.jsoDescriptors = jsoDescriptors;
            this.jsoData = jsoData;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            ArrayList<String> jsoDescList = new ArrayList<String>();
            jsoDescList.addAll(this.jsoDescriptors);
            interfaces = jsoDescList.toArray(new String[jsoDescList.size()]);
            super.visit(version, access, name, signature, superName, interfaces);
            FieldVisitor fv = this.visitField(4100, "properties", "Lcom/googlecode/gwt/test/internal/utils/PropertyContainer;", null, null);
            if (fv != null) {
                fv.visitEnd();
            }
            for (String mangledName : this.jsoData.getMangledNames()) {
                List declarations = this.jsoData.getDeclarations(mangledName);
                List implementations = this.jsoData.getImplementations(mangledName);
                assert (declarations.size() == implementations.size()) : "Declaration / implementation size mismatch";
                Iterator declIterator = declarations.iterator();
                Iterator implIterator = implementations.iterator();
                while (declIterator.hasNext()) {
                    assert (implIterator.hasNext());
                    this.writeTrampoline(mangledName, (Method)declIterator.next(), (Method)implIterator.next());
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isCtor(name)) {
                access &= 0xFFFFFFF9;
                access |= 1;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private void writeTrampoline(String mangledName, Method interfaceMethod, Method implementingMethod) {
            assert (implementingMethod.getArgumentTypes().length > 0);
            String localDescriptor = interfaceMethod.getDescriptor();
            Method localMethod = new Method(mangledName, localDescriptor);
            Type implementingType = Type.getType((String)("L" + implementingMethod.getArgumentTypes()[0].getInternalName() + "$;"));
            MethodVisitor mv = this.visitMethodNoRewrite(4113, localMethod.getName(), localMethod.getDescriptor(), null, null);
            if (mv != null) {
                mv.visitCode();
                int var = 0;
                int size = 0;
                for (Type t : implementingMethod.getArgumentTypes()) {
                    size += t.getSize();
                    mv.visitVarInsn(t.getOpcode(21), var);
                    var += t.getSize();
                }
                size = Math.max(size, implementingMethod.getReturnType().getSize());
                mv.visitMethodInsn(184, implementingType.getInternalName(), implementingMethod.getName(), implementingMethod.getDescriptor());
                mv.visitInsn(localMethod.getReturnType().getOpcode(172));
                mv.visitMaxs(size, var);
                mv.visitEnd();
            }
        }
    }
}

