/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CssResourceReader
implements AfterTestCallback {
    private static final Pattern CSS_CONSTANT_PATTERN = Pattern.compile("^\\s*@def (\\S+)\\s+(\\S+)\\s*$");
    private static final CssResourceReader INSTANCE = new CssResourceReader();
    private final Map<URL, CssParsingResult> cache = new HashMap<URL, CssParsingResult>();

    public static CssResourceReader get() {
        return INSTANCE;
    }

    private CssResourceReader() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() throws Throwable {
        this.cache.clear();
    }

    public CssParsingResult readCss(List<URL> urls) throws IOException {
        HashMap cssConstants = new HashMap();
        for (URL url : urls) {
            cssConstants.putAll(this.readCssFile(url).cssConstants);
        }
        return new CssParsingResult(cssConstants);
    }

    public CssParsingResult readCss(String text) throws IOException {
        return this.parse(new StringReader(text));
    }

    public CssParsingResult readCssFile(URL url) throws IOException {
        CssParsingResult cssConstants = this.cache.get(url);
        if (cssConstants == null) {
            cssConstants = this.parse(new InputStreamReader(url.openStream(), "UTF-8"));
            this.cache.put(url, cssConstants);
        }
        return cssConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CssParsingResult parse(Reader reader) throws IOException {
        HashMap<String, String> cssConstants = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                Matcher m = CSS_CONSTANT_PATTERN.matcher(line);
                if (!m.matches()) continue;
                cssConstants.put(m.group(1), m.group(2));
            }
            CssParsingResult cssParsingResult = new CssParsingResult(cssConstants);
            return cssParsingResult;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CssParsingResult {
        private final Map<String, String> cssConstants;

        private CssParsingResult(Map<String, String> cssConstants) {
            this.cssConstants = cssConstants;
        }

        public String getConstantValue(String name) {
            return this.cssConstants.get(name);
        }
    }
}

