/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.ext.DefaultExtensions;
import com.googlecode.gwt.test.exceptions.GwtTestResourcesException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.resources.ResourcePrototypeProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientBundleProxyFactory {
    private static Map<String, ClientBundleProxyFactory> factoryMap = new HashMap<String, ClientBundleProxyFactory>();
    private final ClientBundleMethodsRegistry methodRegistry;
    private final Class<? extends ClientBundle> proxiedClass;

    public static <T extends ClientBundle> ClientBundleProxyFactory getFactory(Class<T> clazz) {
        ClientBundleProxyFactory factory = factoryMap.get(clazz.getName());
        if (factory == null) {
            factory = new ClientBundleProxyFactory(clazz);
            factoryMap.put(clazz.getName(), factory);
        }
        return factory;
    }

    private ClientBundleProxyFactory(Class<? extends ClientBundle> proxiedClass) {
        this.proxiedClass = proxiedClass;
        this.methodRegistry = new ClientBundleMethodsRegistry(proxiedClass);
    }

    public <T extends ClientBundle> T createProxy() {
        InvocationHandler ih = new InvocationHandler(){
            private final Map<Method, Object> cache = new HashMap<Method, Object>();

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = this.cache.get(method);
                if (result == null) {
                    Class<?> resourcePrototypeClass = method.getReturnType();
                    String name = method.getName();
                    List<URL> resourceURL = ClientBundleProxyFactory.this.methodRegistry.getResourceURL(method);
                    ResourcePrototypeProxyBuilder builder = ResourcePrototypeProxyBuilder.createBuilder(resourcePrototypeClass, ClientBundleProxyFactory.this.proxiedClass).name(name).resourceURLs(resourceURL);
                    result = builder.build();
                    this.cache.put(method, result);
                }
                return result;
            }
        };
        return (T)((ClientBundle)Proxy.newProxyInstance(this.proxiedClass.getClassLoader(), new Class[]{this.proxiedClass}, ih));
    }

    private static class ResourceFileEntry {
        private final Method resourceMethod;
        private final String resourceName;

        public ResourceFileEntry(String resourceName, Method resourceMethod) {
            this.resourceName = resourceName;
            this.resourceMethod = resourceMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientBundleMethodsRegistry {
        private final CtClass ctClass;
        private final Map<Method, List<URL>> resourceURLMap = new HashMap<Method, List<URL>>();

        public ClientBundleMethodsRegistry(Class<? extends ClientBundle> clazz) {
            this.ctClass = GwtClassPool.getCtClass(clazz);
        }

        public List<URL> getResourceURL(Method method) throws Exception {
            List<URL> resourceURLs = this.resourceURLMap.get(method);
            if (resourceURLs == null) {
                resourceURLs = this.computeResourceURLs(method);
                this.resourceURLMap.put(method, resourceURLs);
            }
            return resourceURLs;
        }

        private List<URL> computeResourceURLs(Method method) throws NotFoundException, URISyntaxException {
            ArrayList<ResourceFileEntry> filesSimpleNames = new ArrayList<ResourceFileEntry>();
            boolean computeExtensions = false;
            ClientBundle.Source source = method.getAnnotation(ClientBundle.Source.class);
            if (source != null) {
                for (String value : source.value()) {
                    filesSimpleNames.add(new ResourceFileEntry(value, method));
                }
            }
            if (filesSimpleNames.isEmpty()) {
                filesSimpleNames.add(new ResourceFileEntry(method.getName(), method));
                computeExtensions = true;
            }
            ArrayList<URL> existingFiles = new ArrayList<URL>();
            for (ResourceFileEntry resourceEntry : filesSimpleNames) {
                Class<?> declaringClass;
                String baseDir;
                String resourceNameWithPackage;
                String resourceName = resourceEntry.resourceName;
                String string = resourceNameWithPackage = resourceName.startsWith(baseDir = (declaringClass = resourceEntry.resourceMethod.getDeclaringClass()).getPackage().getName().replaceAll("\\.", "/") + "/") ? resourceName : baseDir + resourceName;
                if (computeExtensions) {
                    String[] extensions;
                    for (String extension : extensions = this.getResourceDefaultExtensions(method)) {
                        String possibleFile = resourceName + extension;
                        URL url = this.getClass().getClassLoader().getResource(possibleFile);
                        if (url != null) {
                            existingFiles.add(url);
                            continue;
                        }
                        String possibleFileWithPackage = resourceNameWithPackage + extension;
                        URL urlWithPackage = this.getClass().getClassLoader().getResource(possibleFileWithPackage);
                        if (urlWithPackage == null) continue;
                        existingFiles.add(urlWithPackage);
                    }
                    continue;
                }
                URL url = this.getClass().getClassLoader().getResource(resourceName);
                if (url != null) {
                    existingFiles.add(url);
                    continue;
                }
                URL urlWithPackage = this.getClass().getClassLoader().getResource(resourceNameWithPackage);
                if (urlWithPackage == null) continue;
                existingFiles.add(urlWithPackage);
            }
            if (existingFiles.isEmpty()) {
                throw new GwtTestResourcesException("No resource file found for method '" + this.ctClass.getName() + "." + method.getName() + "()'");
            }
            return existingFiles;
        }

        private String[] getResourceDefaultExtensions(Method method) {
            DefaultExtensions annotation = method.getReturnType().getAnnotation(DefaultExtensions.class);
            if (annotation == null) {
                throw new GwtTestResourcesException(method.getReturnType().getSimpleName() + " does not define a default extension for resource file. You should use a correct @" + ClientBundle.Source.class.getSimpleName() + " annotation on " + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "() method");
            }
            return annotation.value();
        }
    }
}

