/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.patchers.InitMethod;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(target="com.google.gwt.user.client.ui.PrefixTree")
class PrefixTreePatcher {
    private static final String PREFIXES_SET_PROPERTY = "PREFIXES_SET";

    PrefixTreePatcher() {
    }

    @PatchMethod
    static boolean add(Object prefixTree, String s) {
        return PrefixTreePatcher.getPrefixSet(prefixTree).add(s);
    }

    @PatchMethod
    static void clear(Object prefixTree) {
        GwtReflectionUtils.setPrivateFieldValue(prefixTree, "size", 0);
    }

    @InitMethod
    static void initClass(CtClass c) throws CannotCompileException {
        CtClass pcType = GwtClassPool.getCtClass(Set.class);
        CtField field = new CtField(pcType, PREFIXES_SET_PROPERTY, c);
        field.setModifiers(2);
        c.addField(field);
    }

    @PatchMethod
    static void suggestImpl(Object prefixTree, String search, String prefix, Collection<String> output, int limit) {
        for (String record : PrefixTreePatcher.getPrefixSet(prefixTree)) {
            if (search != null && !record.contains(search.trim().toLowerCase())) continue;
            output.add(record);
        }
    }

    private static Set<String> getPrefixSet(Object prefixTree) {
        TreeSet set = (TreeSet)GwtReflectionUtils.getPrivateFieldValue(prefixTree, PREFIXES_SET_PROPERTY);
        if (set == null) {
            set = new TreeSet();
            GwtReflectionUtils.setPrivateFieldValue(prefixTree, PREFIXES_SET_PROPERTY, set);
        }
        return set;
    }
}

