/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsArrayHelper {
    private static Converter<Boolean> booleanConverter;
    private static Converter<Integer> integerConverter;
    private static final String JSARRAY_WRAPPED_LIST = "JSARRAY_WRAPPED_LIST";
    private static Converter<Object> mixedConverter;
    private static Converter<Double> numberConverter;
    private static Converter<JavaScriptObject> objectConverter;
    private static Converter<String> stringConverter;

    JsArrayHelper() {
    }

    public static <T> T get(JavaScriptObject jsArray, int index, Converter<T> converter) {
        List<Object> wrapped = JsArrayHelper.getWrappedList(jsArray);
        Object o = index < wrapped.size() ? wrapped.get(index) : null;
        return converter.convert(o);
    }

    public static Converter<Boolean> getBooleanConverter() {
        if (booleanConverter == null) {
            booleanConverter = new Converter<Boolean>(){

                @Override
                public Boolean convert(Object o) {
                    return o != null ? Boolean.valueOf(o.toString()) : false;
                }

                @Override
                public String serialize(Object o) {
                    return o != null ? o.toString() : "";
                }
            };
        }
        return booleanConverter;
    }

    public static Converter<Integer> getIntegerConverter() {
        if (integerConverter == null) {
            integerConverter = new Converter<Integer>(){

                @Override
                public Integer convert(Object o) {
                    return o != null ? Integer.valueOf(o.toString()) : 0;
                }

                @Override
                public String serialize(Object o) {
                    return o != null ? o.toString() : "";
                }
            };
        }
        return integerConverter;
    }

    public static Converter<Object> getMixedConverter() {
        if (mixedConverter == null) {
            mixedConverter = new Converter<Object>(){

                @Override
                public Object convert(Object o) {
                    return o;
                }

                @Override
                public String serialize(Object o) {
                    if (o == null) {
                        return "";
                    }
                    if (o instanceof JavaScriptObject) {
                        return JsArrayHelper.getObjectConverter().serialize(o);
                    }
                    return o.toString();
                }
            };
        }
        return mixedConverter;
    }

    public static Converter<Double> getNumberConverter() {
        if (numberConverter == null) {
            numberConverter = new Converter<Double>(){

                @Override
                public Double convert(Object o) {
                    return o != null ? Double.valueOf(o.toString()) : 0.0;
                }

                @Override
                public String serialize(Object o) {
                    return o != null ? o.toString() : "";
                }
            };
        }
        return numberConverter;
    }

    public static Converter<JavaScriptObject> getObjectConverter() {
        if (objectConverter == null) {
            objectConverter = new Converter<JavaScriptObject>(){

                @Override
                public JavaScriptObject convert(Object o) {
                    if (o == null) {
                        return null;
                    }
                    if (o instanceof JavaScriptObject) {
                        return (JavaScriptObject)o;
                    }
                    return JsonUtils.safeEval((String)o.toString());
                }

                @Override
                public String serialize(Object o) {
                    if (o == null) {
                        return "";
                    }
                    if (o instanceof JavaScriptObject) {
                        JavaScriptObject jso = (JavaScriptObject)o;
                        return JsoUtils.serialize(jso);
                    }
                    return o.toString();
                }
            };
        }
        return objectConverter;
    }

    public static Converter<String> getStringConverter() {
        if (stringConverter == null) {
            stringConverter = new Converter<String>(){

                @Override
                public String convert(Object o) {
                    if (o == null) {
                        return null;
                    }
                    if (o instanceof JavaScriptObject) {
                        return JsoUtils.serialize((JavaScriptObject)o);
                    }
                    return o.toString();
                }

                @Override
                public String serialize(Object o) {
                    if (o == null) {
                        return "";
                    }
                    if (o instanceof JavaScriptObject) {
                        return JsoUtils.serialize((JavaScriptObject)o);
                    }
                    return o.toString();
                }
            };
        }
        return stringConverter;
    }

    public static List<Object> getWrappedList(JavaScriptObject jsArray) {
        ArrayList wrappedList = (ArrayList)JavaScriptObjects.getObject(jsArray, JSARRAY_WRAPPED_LIST);
        if (wrappedList == null) {
            wrappedList = new ArrayList();
            JavaScriptObjects.setProperty(jsArray, JSARRAY_WRAPPED_LIST, wrappedList);
        }
        return wrappedList;
    }

    public static <T> String join(JavaScriptObject jsArray, String separator, Converter<T> converter) {
        StringBuilder sb = new StringBuilder();
        for (Object o : JsArrayHelper.getWrappedList(jsArray)) {
            sb.append(converter.serialize(o));
            sb.append(separator);
        }
        return sb.substring(0, sb.length() - separator.length());
    }

    public static int length(JavaScriptObject jsArray) {
        return JsArrayHelper.getWrappedList(jsArray).size();
    }

    public static void push(JavaScriptObject jsArray, Object value) {
        JsArrayHelper.getWrappedList(jsArray).add(value);
    }

    public static void set(JavaScriptObject jsArray, int index, Object value) {
        List<Object> wrapped = JsArrayHelper.getWrappedList(jsArray);
        int currentSize = wrapped.size();
        if (index >= currentSize) {
            for (int i = currentSize; i <= index; ++i) {
                wrapped.add(null);
            }
        }
        wrapped.set(index, value);
    }

    public static void setLength(JavaScriptObject jsArray, int newLength) {
        block3: {
            int currentSize;
            List<Object> list;
            block2: {
                list = JsArrayHelper.getWrappedList(jsArray);
                currentSize = list.size();
                if (currentSize <= newLength) break block2;
                for (int i = newLength; i < currentSize; ++i) {
                    list.remove(i - 1);
                }
                break block3;
            }
            if (currentSize >= newLength) break block3;
            for (int i = currentSize; i <= newLength; ++i) {
                list.add(null);
            }
        }
    }

    public static <T> T shift(JavaScriptObject jsArray, Converter<T> converter) {
        List<Object> wrapped = JsArrayHelper.getWrappedList(jsArray);
        if (wrapped.size() == 0) {
            return null;
        }
        Object o = wrapped.remove(0);
        return converter.convert(o);
    }

    public static void unshift(JavaScriptObject jsArray, Object value) {
        JsArrayHelper.getWrappedList(jsArray).add(0, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Converter<T> {
        public T convert(Object var1);

        public String serialize(Object var1);
    }
}

