/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.Text;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.internal.utils.PropertyContainer;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.Map;

@PatchClass(value=JavaScriptObject.class)
class JavaScriptObjectPatcher {
    JavaScriptObjectPatcher() {
    }

    @PatchMethod
    static JavaScriptObject createArray() {
        return JavaScriptObjectPatcher.createObject();
    }

    @PatchMethod
    static JavaScriptObject createFunction() {
        return JavaScriptObjectPatcher.createObject();
    }

    @PatchMethod
    static JavaScriptObject createObject() {
        try {
            Class<?> clazz = Class.forName("com.google.gwt.core.client.JavaScriptObject$");
            return (JavaScriptObject)GwtReflectionUtils.instantiateClass(clazz);
        }
        catch (Exception e) {
            throw new GwtTestPatchException("Error while instanciating JavaScriptObject :", e);
        }
    }

    @PatchMethod
    static String toString(JavaScriptObject jso) {
        short nodeType = ((Node)jso.cast()).getNodeType();
        switch (nodeType) {
            case 9: {
                return JavaScriptObjectPatcher.documentToString((Document)jso.cast());
            }
            case 3: {
                Text text = (Text)jso.cast();
                return "'" + text.getData() + "'";
            }
            case 1: {
                return JavaScriptObjectPatcher.elementToString((Element)jso.cast());
            }
        }
        if (JsoUtils.isNodeList(jso)) {
            NodeList nodeList = (NodeList)jso.cast();
            return JsoUtils.getChildNodeInnerList(nodeList).toString();
        }
        if (GwtStyleUtils.isStyle(jso)) {
            Style style = (Style)jso.cast();
            return GwtStyleUtils.toString(style);
        }
        return jso.getClass().getSimpleName();
    }

    private static String documentToString(Document document) {
        StringBuilder html = new StringBuilder();
        NodeList childs = document.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.getItem(i);
            html.append(child.toString());
        }
        return html.toString();
    }

    private static String elementToString(Element elem) {
        String tagName;
        String string = tagName = JsoUtils.isXmlElement((JavaScriptObject)elem) ? elem.getTagName() : elem.getTagName().toLowerCase();
        if ("br".equals(tagName)) {
            return "<br>" + elem.getInnerText();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tagName).append(" ");
        PropertyContainer attrs = JsoUtils.getDomProperties(elem);
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if ("disabled".equals(entry.getKey())) {
                Boolean disabled = (Boolean)entry.getValue();
                if (!disabled.booleanValue()) continue;
                sb.append(entry.getKey()).append("=\"\" ");
                continue;
            }
            if ("className".equals(entry.getKey())) {
                sb.append("class=\"").append(entry.getValue()).append("\" ");
                continue;
            }
            if ("style".equals(entry.getKey())) {
                String style = elem.getStyle().toString();
                if ("".equals(style)) continue;
                sb.append("style=\"").append(elem.getStyle().toString()).append("\" ");
                continue;
            }
            sb.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        String innerHtml = elem.getInnerHTML();
        if (JsoUtils.isXmlElement((JavaScriptObject)elem) && innerHtml.trim().length() == 0) {
            sb.append("/>");
        } else {
            sb.append(">").append(elem.getInnerHTML());
            sb.append("</").append(tagName).append(">");
        }
        return sb.toString();
    }
}

