/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.i18n;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.googlecode.gwt.test.exceptions.GwtTestI18NException;
import com.googlecode.gwt.test.internal.i18n.LocalizableResourceInvocationHandler;
import com.googlecode.gwt.test.internal.utils.GwtPropertiesHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantsInvocationHandler
extends LocalizableResourceInvocationHandler {
    public ConstantsInvocationHandler(Class<? extends LocalizableResource> proxiedClass) {
        super(proxiedClass);
    }

    @Override
    protected Object extractDefaultValue(Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        if (returnType == String.class) {
            Constants.DefaultStringValue a = this.getCheckedAnnotation(method, Constants.DefaultStringValue.class);
            return this.treatLine(a.value());
        }
        if (returnType == SafeHtml.class) {
            Constants.DefaultStringValue a = this.getCheckedAnnotation(method, Constants.DefaultStringValue.class);
            return SafeHtmlUtils.fromTrustedString((String)this.treatLine(a.value()));
        }
        if (returnType.isArray() && returnType.getComponentType() == String.class) {
            Constants.DefaultStringArrayValue a = this.getCheckedAnnotation(method, Constants.DefaultStringArrayValue.class);
            String[] v = a.value();
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.treatLine(v[i]);
            }
            return v;
        }
        if (returnType == Map.class) {
            Constants.DefaultStringMapValue a = this.getCheckedAnnotation(method, Constants.DefaultStringMapValue.class);
            String[] v = a.value();
            if (v.length % 2 != 0) {
                throw new GwtTestI18NException("@" + Constants.DefaultStringMapValue.class.getSimpleName() + " value incorrect for method " + method.getDeclaringClass().getName() + "." + method.getName() + "() : the array value (key/value pair) should be even");
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (int i = 0; i < v.length; ++i) {
                result.put(v[i], this.treatLine(v[++i]));
            }
            return result;
        }
        if (returnType == Integer.class || returnType == Integer.TYPE) {
            Constants.DefaultIntValue a = this.getCheckedAnnotation(method, Constants.DefaultIntValue.class);
            return a.value();
        }
        if (returnType == Double.class || returnType == Double.TYPE) {
            Constants.DefaultDoubleValue a = this.getCheckedAnnotation(method, Constants.DefaultDoubleValue.class);
            return a.value();
        }
        if (returnType == Float.class || returnType == Float.TYPE) {
            Constants.DefaultFloatValue a = this.getCheckedAnnotation(method, Constants.DefaultFloatValue.class);
            return Float.valueOf(a.value());
        }
        if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            Constants.DefaultBooleanValue a = this.getCheckedAnnotation(method, Constants.DefaultBooleanValue.class);
            return a.value();
        }
        throw new GwtTestI18NException("The return type (" + returnType.getSimpleName() + ") of i18n '" + this.getProxiedClass().getSimpleName() + "." + method.getName() + "()' is not managed");
    }

    @Override
    protected Object extractFromProperties(Properties properties, Method method, Object[] args, Locale locale) throws Throwable {
        String line = properties.getProperty(this.getKey(method));
        if (line == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == String.class) {
            return line;
        }
        if (returnType == SafeHtml.class) {
            return SafeHtmlUtils.fromTrustedString((String)line);
        }
        if (returnType.isArray() && returnType.getComponentType() == String.class) {
            return line.split("\\s*,\\s*");
        }
        if (returnType == Map.class) {
            String[] v;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : v = line.split("\\s*,\\s*")) {
                result.put(key, properties.get(key));
            }
            return result;
        }
        if (returnType == Integer.class || returnType == Integer.TYPE) {
            return Integer.parseInt(line);
        }
        if (returnType == Double.class || returnType == Double.TYPE) {
            return Double.parseDouble(line);
        }
        if (returnType == Float.class || returnType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(line));
        }
        if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            return Boolean.parseBoolean(line);
        }
        throw new GwtTestI18NException("The return type (" + returnType.getSimpleName() + ") of i18n '" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()' is not managed");
    }

    private <T extends Annotation> T getCheckedAnnotation(Method method, Class<T> defaultAnnotation) {
        T v = method.getAnnotation(defaultAnnotation);
        if (v == null) {
            throw new GwtTestI18NException("No matching property \"" + method.getName() + "\" for Constants class [" + this.getProxiedClass().getCanonicalName() + "]. Please check the corresponding properties files or use @" + defaultAnnotation.getSimpleName());
        }
        return v;
    }

    private String treatLine(String line) {
        return GwtPropertiesHelper.get().treatString(line);
    }
}

