/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.google.gwt.place.impl.AbstractPlaceHistoryMapper;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.google.gwt.place.shared.WithTokenizers;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlaceHistoryMapperCreateHandler
implements GwtCreateHandler {
    PlaceHistoryMapperCreateHandler() {
    }

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        if (!PlaceHistoryMapper.class.isAssignableFrom(classLiteral)) {
            return null;
        }
        WithTokenizers withTokenizers = classLiteral.getAnnotation(WithTokenizers.class);
        if (withTokenizers == null) {
            throw new GwtTestPatchException("Error while trying to create an instance of " + classLiteral.getName() + " : gwt-test-utils default GwtCreateHandler for PlaceHistoryMapper is not currently able to create a valid implementation without relying on the @WithTokenizer annotation");
        }
        return Proxy.newProxyInstance(classLiteral.getClassLoader(), new Class[]{classLiteral}, (InvocationHandler)new PlaceHistoryInvocationHandler(withTokenizers.value()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PlaceHistoryInvocationHandler
    implements InvocationHandler {
        private final GwtTestPlaceHistoryMapper placeHistoryMapper;

        private PlaceHistoryInvocationHandler(Class<? extends PlaceTokenizer<?>>[] placeTokenizers) {
            this.placeHistoryMapper = new GwtTestPlaceHistoryMapper(placeTokenizers);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getPlace")) {
                return this.placeHistoryMapper.getPlace((String)args[0]);
            }
            if (method.getName().equals("getToken")) {
                return this.placeHistoryMapper.getToken((Place)args[0]);
            }
            throw new GwtTestPatchException("Unhandled method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' by the default gwt-test-utils GwtCreateHandler for PlaceHistoryMapper subtypes");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GwtTestPlaceHistoryMapper
    extends AbstractPlaceHistoryMapper<Object> {
        private final Map<Class<?>, String> prefixMap = new HashMap();
        private final Map<String, PlaceTokenizer<?>> tokenizerMap = new HashMap();

        private GwtTestPlaceHistoryMapper(Class<? extends PlaceTokenizer<?>>[] placeTokenizers) {
            this.collectTokenizerByPrefix(placeTokenizers);
        }

        protected AbstractPlaceHistoryMapper.PrefixAndToken getPrefixAndToken(Place newPlace) {
            String prefix = this.prefixMap.get(newPlace.getClass());
            PlaceTokenizer<?> tokenizer = this.getTokenizer(prefix);
            if (tokenizer == null) {
                return null;
            }
            String token = (String)GwtReflectionUtils.callPrivateMethod(tokenizer, "getToken", newPlace);
            return new AbstractPlaceHistoryMapper.PrefixAndToken(prefix, token);
        }

        protected PlaceTokenizer<?> getTokenizer(String prefix) {
            return this.tokenizerMap.get(prefix);
        }

        private void collectTokenizerByPrefix(Class<? extends PlaceTokenizer<?>>[] placeTokenizers) {
            for (Class<PlaceTokenizer<?>> clazz : placeTokenizers) {
                try {
                    Method getPlaceMethod = clazz.getMethod("getPlace", String.class);
                    Class<?> placeClass = getPlaceMethod.getReturnType();
                    String placePrefix = this.createUniquePrefix(placeClass);
                    PlaceTokenizer<?> instance = GwtReflectionUtils.instantiateClass(clazz);
                    this.tokenizerMap.put(placePrefix, instance);
                    this.prefixMap.put(placeClass, placePrefix);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private String createUniquePrefix(Class<?> placeClass) {
            String prefix;
            String uniquePrefix = prefix = placeClass.getSimpleName();
            int i = 1;
            while (this.tokenizerMap.containsKey(uniquePrefix)) {
                uniquePrefix = prefix + i;
                ++i;
            }
            return uniquePrefix;
        }
    }
}

