/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.RebindCache;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.PropertyPermutations;
import com.google.gwt.dev.cfg.StaticPropertyOracle;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.shell.DispatchIdOracle;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.util.Name;
import com.google.gwt.junit.client.WithProperties;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.GwtTreeLogger;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.GwtFactory;
import com.googlecode.gwt.test.internal.GwtTestDataHolder;
import com.googlecode.gwt.test.internal.handlers.GwtTestModuleSpaceHost;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorCreateHandler
implements GwtCreateHandler {
    private static Map<String, ModuleSpaceHost> moduleSpaceHosts = new HashMap<String, ModuleSpaceHost>();
    private static final RebindCache REBIND_CACHE = new RebindCache();
    protected Map<String, CompiledClass> compiledClassMap = new HashMap<String, CompiledClass>();
    private final CompilationState compilationState;
    private final TreeLogger logger = GwtTreeLogger.get();
    private final ModuleDef moduleDef;
    private PropertyOracle propertyOracle;

    public GeneratorCreateHandler(CompilationState compilationState, ModuleDef moduleDef) {
        this.compilationState = compilationState;
        this.moduleDef = moduleDef;
    }

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        Class<?> c = this.generate(classLiteral);
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            return null;
        }
        return GwtReflectionUtils.instantiateClass(c);
    }

    public Class<?> generate(Class<?> classLiteral) throws UnableToCompleteException {
        CompiledClass compiledClass = this.compile(classLiteral.getCanonicalName());
        if (compiledClass == null) {
            return classLiteral;
        }
        try {
            return GwtFactory.get().getClassLoader().loadClass(compiledClass.getSourceName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ModuleDef getGwtModule() {
        return this.moduleDef;
    }

    protected PropertyOracle getPropertyOracle() {
        if (this.propertyOracle == null) {
            PropertyPermutations permutations = new PropertyPermutations(this.moduleDef.getProperties(), this.moduleDef.getActiveLinkerNames());
            SortedSet configPropSet = this.moduleDef.getProperties().getConfigurationProperties();
            ConfigurationProperty[] configProps = configPropSet.toArray(new ConfigurationProperty[configPropSet.size()]);
            BindingProperty[] orderedProperties = permutations.getOrderedProperties();
            WithProperties withProperties = GwtTestDataHolder.get().getCurrentWithProperties();
            String[] processedProperties = withProperties != null ? this.replaceOrderedPropertyValues(orderedProperties, permutations.getOrderedPropertyValues(0), withProperties) : permutations.getOrderedPropertyValues(0);
            this.propertyOracle = new StaticPropertyOracle(orderedProperties, processedProperties, configProps);
        }
        return this.propertyOracle;
    }

    private CompiledClass compile(String literalName) throws UnableToCompleteException {
        CompiledClass compiledClass = this.compiledClassMap.get(literalName);
        if (compiledClass != null) {
            this.logger.log(TreeLogger.Type.INFO, "Using cached resource for " + literalName);
            return compiledClass;
        }
        if (this.moduleDef == null) {
            throw new RuntimeException("Gwt module is not set.");
        }
        this.logger.log(TreeLogger.Type.INFO, "Generating " + literalName);
        String className = this.getModuleSpaceHost().rebind(this.logger, literalName);
        String internalName = Name.BinaryName.toInternalName((String)className);
        compiledClass = (CompiledClass)this.compilationState.getClassFileMap().get(internalName);
        if (compiledClass != null) {
            this.compiledClassMap.put(literalName, compiledClass);
        }
        return compiledClass;
    }

    private ModuleSpace createModuleSpace(ModuleSpaceHost host) {
        return new ModuleSpace((TreeLogger)GwtTreeLogger.get(), host, this.moduleDef.getCanonicalName()){

            public void createNativeMethods(TreeLogger logger, List<JsniMethod> jsniMethods, DispatchIdOracle dispatchIdOracle) {
                throw new UnsupportedOperationException("ModuleSpace.createNativeMethods(..) not supported by gwt-test-utils");
            }

            protected void createStaticDispatcher(TreeLogger logger) {
                throw new UnsupportedOperationException("ModuleSpace.createStaticDispatcher(..) not supported by gwt-test-utils");
            }

            protected JsValue doInvoke(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("ModuleSpace.doInvoke(..) not supported by gwt-test-utils");
            }

            protected Object getStaticDispatcher() {
                throw new UnsupportedOperationException("ModuleSpace.getStaticDispatcher() not supported by gwt-test-utils");
            }
        };
    }

    private ModuleSpaceHost createModuleSpaceHost(CompilationState compilationState, ModuleDef moduleDef) {
        try {
            GwtTestModuleSpaceHost moduleSpaceHost = new GwtTestModuleSpaceHost((TreeLogger)GwtTreeLogger.get(), compilationState, moduleDef, null, null, REBIND_CACHE);
            ModuleSpace moduleSpace = this.createModuleSpace(moduleSpaceHost);
            moduleSpaceHost.onModuleReady(moduleSpace);
            return moduleSpaceHost;
        }
        catch (UnableToCompleteException e) {
            throw new GwtTestConfigurationException("Error while creating global ModuleSpaceHost :", e);
        }
    }

    private ModuleSpaceHost getModuleSpaceHost() {
        WithProperties withProperties = GwtTestDataHolder.get().getCurrentWithProperties();
        String serializedProperties = this.serialize(withProperties);
        ModuleSpaceHost moduleSpaceHost = moduleSpaceHosts.get(serializedProperties);
        if (moduleSpaceHost == null) {
            moduleSpaceHost = this.createModuleSpaceHost(this.compilationState, this.moduleDef);
            moduleSpaceHosts.put(serializedProperties, moduleSpaceHost);
        }
        return moduleSpaceHost;
    }

    private TreeMap<String, String> propertiesToTreeMap(WithProperties withProperties) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (WithProperties.Property property : withProperties.value()) {
            treeMap.put(property.name(), property.value());
        }
        return treeMap;
    }

    private String[] replaceOrderedPropertyValues(BindingProperty[] orderedProperties, String[] orderedOriginalValues, WithProperties withProperties) {
        TreeMap<String, String> propertiesOverrides = this.propertiesToTreeMap(withProperties);
        String[] result = new String[orderedProperties.length];
        for (int i = 0; i < orderedProperties.length; ++i) {
            result[i] = propertiesOverrides.containsKey(orderedProperties[i].getName()) ? (String)propertiesOverrides.get(orderedProperties[i].getName()) : orderedOriginalValues[i];
        }
        return result;
    }

    private String serialize(WithProperties withProperties) {
        return withProperties != null ? this.propertiesToTreeMap(withProperties).toString() : "";
    }
}

