/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.AutomaticPatcher;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.OverlayPatcher;
import com.googlecode.gwt.test.internal.Patcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatcherFactory {
    private static final CtClass jsoClass = GwtClassPool.getClass("com.google.gwt.core.client.JavaScriptObject");
    private final Map<String, Patcher> patchers = new HashMap<String, Patcher>();

    PatcherFactory(Map<String, Set<CtClass>> patchClassMap) {
        for (Map.Entry<String, Set<CtClass>> entry : patchClassMap.entrySet()) {
            Patcher patcher = this.createPatcher(entry.getValue());
            if (patcher == null) continue;
            this.patchers.put(entry.getKey(), patcher);
        }
    }

    Patcher createPatcher(CtClass classToPatch) {
        Patcher patcher = this.patchers.get(classToPatch.getName());
        try {
            if (classToPatch.subtypeOf(jsoClass) && classToPatch != jsoClass) {
                patcher = new OverlayPatcher(patcher);
            }
        }
        catch (NotFoundException e) {
            throw new GwtTestPatchException(e);
        }
        return patcher;
    }

    private Patcher createPatcher(Set<CtClass> patchClasses) {
        if (patchClasses != null && patchClasses.size() > 0) {
            return new AutomaticPatcher(patchClasses);
        }
        return null;
    }
}

