/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.Patcher;
import com.googlecode.gwt.test.patchers.InitMethod;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.StringMemberValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AutomaticPatcher
implements Patcher {
    private final CtMethod initMethod;
    private final Set<CtMethod> patchMethods;
    private final Set<CtMethod> processedMethods;

    AutomaticPatcher(Set<CtClass> patchClasses) {
        for (CtClass patchClass : patchClasses) {
            patchClass.setModifiers(1);
        }
        this.initMethod = this.getInitMethod(patchClasses);
        this.patchMethods = this.getPatchMethods(patchClasses);
        this.processedMethods = new HashSet<CtMethod>();
    }

    @Override
    public void finalizeClass(CtClass c) throws Exception {
    }

    @Override
    public String getNewBody(CtMethod m) throws Exception {
        CtMethod patchMethod = this.findPatchMethod(m);
        if (patchMethod == null) {
            return null;
        }
        this.processedMethods.add(patchMethod);
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        buffer.append("return ");
        buffer.append(patchMethod.getDeclaringClass().getName() + "." + patchMethod.getName());
        buffer.append("(");
        boolean append = false;
        if (!Modifier.isStatic(m.getModifiers())) {
            buffer.append("this");
            append = true;
        }
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            if (append) {
                buffer.append(", ");
            }
            int j = i + 1;
            buffer.append("$" + j);
            append = true;
        }
        buffer.append(");");
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void initClass(CtClass c) throws Exception {
        if (this.initMethod == null) {
            return;
        }
        Class<?> clazz = GwtReflectionUtils.getClass(this.initMethod.getDeclaringClass().getName());
        Method compiledMethod = clazz.getDeclaredMethod(this.initMethod.getName(), CtClass.class);
        GwtReflectionUtils.makeAccessible(compiledMethod);
        try {
            compiledMethod.invoke(null, c);
        }
        catch (InvocationTargetException e) {
            if (Exception.class.isInstance(e)) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private String[] extractPatchMethodParameterTypes(CtMethod patchMethod, boolean isStatic) throws NotFoundException, ClassNotFoundException {
        int i;
        CtClass[] patchMethodParamTypes = patchMethod.getParameterTypes();
        int length = isStatic ? patchMethodParamTypes.length : patchMethodParamTypes.length - 1;
        String[] result = new String[length];
        Object[][] parameterAnntations = patchMethod.getParameterAnnotations();
        int n = i = isStatic ? 0 : 1;
        while (i < patchMethodParamTypes.length) {
            Object[] annotations = parameterAnntations[i];
            String paramType = null;
            if (annotations.length > 0) {
                paramType = this.tryExtractFromParamTypeAnnotation(annotations);
            }
            if (paramType == null) {
                paramType = patchMethodParamTypes[i].getName();
            }
            result[isStatic ? i : i - 1] = paramType;
            ++i;
        }
        return result;
    }

    private CtMethod findPatchMethod(CtMethod m) throws Exception {
        for (CtMethod patchMethod : this.patchMethods) {
            String methodName;
            PatchMethod annotation = (PatchMethod)patchMethod.getAnnotation(PatchMethod.class);
            String string = methodName = annotation.value().length() > 0 ? annotation.value() : patchMethod.getName();
            if (!m.getName().equals(methodName) || !this.hasCompatibleSignature(m, patchMethod)) continue;
            return patchMethod;
        }
        return null;
    }

    private CtMethod getInitMethod(Set<CtClass> patchClasses) {
        ArrayList<CtMethod> initMethods = new ArrayList<CtMethod>();
        for (CtClass patchClass : patchClasses) {
            for (CtMethod ctMethod : patchClass.getDeclaredMethods()) {
                if (!ctMethod.hasAnnotation(InitMethod.class)) continue;
                if (!Modifier.isStatic(ctMethod.getModifiers())) {
                    throw new GwtTestPatchException("@" + InitMethod.class.getSimpleName() + " has to be static : '" + ctMethod.getLongName() + "'");
                }
                try {
                    if (ctMethod.getParameterTypes().length != 1 || ctMethod.getParameterTypes()[0] != GwtClassPool.getCtClass(CtClass.class)) {
                        throw new GwtTestPatchException("@" + InitMethod.class.getName() + " method must have one and only one parameter of type '" + CtClass.class.getName() + "'");
                    }
                }
                catch (NotFoundException e) {
                    throw new GwtTestPatchException(e);
                }
                initMethods.add(ctMethod);
            }
        }
        CtMethod initMethod = this.getMethodToUse(initMethods, InitMethod.class);
        if (initMethod != null) {
            initMethod.setModifiers(9);
        }
        return initMethod;
    }

    private <T extends Annotation> T getMethodAnnotation(CtMethod ctMethod, Class<T> annotation) {
        try {
            return (T)((Annotation)ctMethod.getAnnotation(annotation));
        }
        catch (ClassNotFoundException e) {
            throw new GwtTestPatchException(e);
        }
    }

    private <T extends Annotation> CtMethod getMethodToUse(List<CtMethod> methods, Class<T> annotationClass) {
        switch (methods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return methods.get(0);
            }
        }
        return this.getOverrideMethod(methods, annotationClass);
    }

    private <T extends Annotation> CtMethod getOverrideMethod(List<CtMethod> methods, Class<T> annotationClass) {
        CtMethod overrideInitMethod = null;
        for (CtMethod method : methods) {
            T annotation = this.getMethodAnnotation(method, annotationClass);
            if (!this.isOverride((Annotation)annotation)) continue;
            if (overrideInitMethod != null) {
                throw new GwtTestPatchException("There are more than one @" + annotationClass.getSimpleName() + " with 'override=true' for the same target : '" + method.getLongName() + "' and '" + overrideInitMethod.getLongName() + "'");
            }
            overrideInitMethod = method;
        }
        if (overrideInitMethod == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(methods.size()).append(" @");
            sb.append(annotationClass.getSimpleName());
            sb.append(" methods detected for the same target, but no one is set to override the other. You must use 'override=true' on the one which should be applied : ");
            for (CtMethod method : methods) {
                sb.append("'").append(method.getLongName()).append("'");
                sb.append(" or ");
            }
            throw new GwtTestPatchException(sb.substring(0, sb.length() - 4));
        }
        return overrideInitMethod;
    }

    private Set<CtMethod> getPatchMethods(Set<CtClass> patchClasses) {
        HashSet<CtMethod> result = new HashSet<CtMethod>();
        HashMap<String, ArrayList<CtMethod>> temp = new HashMap<String, ArrayList<CtMethod>>();
        for (CtClass ctClass : patchClasses) {
            for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                if (!ctMethod.hasAnnotation(PatchMethod.class)) continue;
                if (!Modifier.isStatic(ctMethod.getModifiers())) {
                    throw new GwtTestPatchException("@" + PatchMethod.class.getName() + " has to be static : '" + ctMethod.getLongName() + "'");
                }
                String nameAndSignature = ctMethod.getName() + Descriptor.toString((String)ctMethod.getSignature());
                ArrayList<CtMethod> correspondingMethods = (ArrayList<CtMethod>)temp.get(nameAndSignature);
                if (correspondingMethods == null) {
                    correspondingMethods = new ArrayList<CtMethod>();
                    temp.put(nameAndSignature, correspondingMethods);
                }
                correspondingMethods.add(ctMethod);
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            CtMethod methodToUse = this.getMethodToUse((List)entry.getValue(), PatchMethod.class);
            methodToUse.setModifiers(9);
            result.add(methodToUse);
        }
        return result;
    }

    private boolean hasCompatibleSignature(CtMethod methodFound, CtMethod patchMethod) throws Exception {
        String[] patchMethodParamTypes;
        boolean isStatic = Modifier.isStatic(methodFound.getModifiers());
        if (!(isStatic || patchMethod.getParameterTypes().length != 0 && methodFound.getDeclaringClass().subtypeOf(patchMethod.getParameterTypes()[0]))) {
            return false;
        }
        CtClass[] orgMethodParamTypes = methodFound.getParameterTypes();
        if (orgMethodParamTypes.length != (patchMethodParamTypes = this.extractPatchMethodParameterTypes(patchMethod, isStatic)).length) {
            return false;
        }
        for (int i = 0; i < orgMethodParamTypes.length; ++i) {
            if (orgMethodParamTypes[i].getName().equals(patchMethodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isOverride(Annotation annotation) {
        if (InitMethod.class.isInstance(annotation)) {
            return ((InitMethod)annotation).override();
        }
        return ((PatchMethod)annotation).override();
    }

    private String tryExtractFromParamTypeAnnotation(Object[] annotations) {
        for (Object o : annotations) {
            AnnotationImpl annotation = (AnnotationImpl)Proxy.getInvocationHandler(o);
            if (!annotation.getTypeName().equals(PatchMethod.ParamType.class.getName())) continue;
            String value = ((StringMemberValue)annotation.getAnnotation().getMemberValue("value")).getValue();
            return value.equals("") ? null : value;
        }
        return null;
    }
}

