/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.gin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.inject.client.AsyncProvider;
import com.google.gwt.inject.client.Ginjector;
import com.google.gwt.inject.rebind.reflect.ReflectUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.gin.GwtTestGinException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeferredBindingModule
extends AbstractModule {
    private static final Map<Class<?>, DeferredBindingModule> DEFERRED_BINDING_MODULES_CACHE = new HashMap();
    private static final Map<String, Class<Object>> GENERATED = new HashMap<String, Class<Object>>();
    private static final Map<Class<?>, Boolean> HAS_INJECTION_ANNOTATION_CACHE = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(DeferredBindingModule.class);
    private final Set<Key<?>> bindedClasses;
    private final Set<Key<?>> classesToInstanciate;
    private final Class<? extends Ginjector> ginInjectorClass;

    static final DeferredBindingModule getDeferredBindingModule(Class<? extends Ginjector> ginInjectorClass, Collection<Module> modules) {
        DeferredBindingModule deferredBindingModule = DEFERRED_BINDING_MODULES_CACHE.get(ginInjectorClass);
        if (deferredBindingModule == null) {
            deferredBindingModule = new DeferredBindingModule(ginInjectorClass, modules.toArray(new Module[modules.size()]));
            DEFERRED_BINDING_MODULES_CACHE.put(ginInjectorClass, deferredBindingModule);
        }
        return deferredBindingModule;
    }

    private DeferredBindingModule(Class<? extends Ginjector> ginInjectorClass, Module[] modules) {
        this.ginInjectorClass = ginInjectorClass;
        List elements = Elements.getElements((Module[])modules);
        this.classesToInstanciate = this.collectClassesFromInjector(ginInjectorClass);
        this.classesToInstanciate.addAll(this.collectDependencies(elements));
        this.bindedClasses = this.collectBindedClasses(elements);
    }

    protected void configure() {
        HashSet copy = new HashSet(this.bindedClasses);
        this.addDeferredBindings(this.classesToInstanciate, copy);
    }

    private void addDeferredBinding(Key<?> toInstanciate, Set<Key<?>> bindedClasses) {
        bindedClasses.add(toInstanciate);
        if (this.isProviderKey(toInstanciate)) {
            Key providedKey = ReflectUtil.getProvidedKey(toInstanciate);
            if (!bindedClasses.contains(providedKey)) {
                bindedClasses.add(providedKey);
                HashSet collected = new HashSet();
                this.collectDependencies(providedKey, collected);
                this.addDeferredBindings(collected, bindedClasses);
            }
        } else if (this.isAsyncProviderKey(toInstanciate)) {
            Class<Object> asyncProviderClass = this.getAsyncProvider(toInstanciate);
            this.bind(toInstanciate).to(asyncProviderClass);
            Key providedKey = ReflectUtil.getProvidedKey(toInstanciate);
            if (!bindedClasses.contains(providedKey)) {
                bindedClasses.add(providedKey);
                HashSet collected = new HashSet();
                this.collectDependencies(providedKey, collected);
                this.addDeferredBindings(collected, bindedClasses);
            }
        } else if (this.hasAnyGuiceAnnotation(toInstanciate.getTypeLiteral().getRawType())) {
            this.bind(toInstanciate);
        } else {
            this.bind(toInstanciate).toProvider((Provider)new DeferredBindingProvider(this.ginInjectorClass, toInstanciate));
        }
    }

    private void addDeferredBindings(Set<Key<?>> classesToInstanciate, Set<Key<?>> bindedClasses) {
        for (Key<?> toInstanciate : classesToInstanciate) {
            if (bindedClasses.contains(toInstanciate)) continue;
            this.addDeferredBinding(toInstanciate, bindedClasses);
        }
    }

    private Set<Key<?>> collectBindedClasses(List<Element> elements) {
        final HashSet bindedClasses = new HashSet();
        for (Element e : elements) {
            e.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    bindedClasses.add(binding.getKey());
                    return null;
                }
            });
        }
        return bindedClasses;
    }

    private Set<Key<?>> collectClassesFromInjector(Class<?> injectorClass) {
        HashSet classesToInstanciate = new HashSet();
        for (Method m : injectorClass.getMethods()) {
            if (m.getGenericParameterTypes().length > 0) {
                LOGGER.warn("skipping method '" + m.toGenericString() + "' because it has non-zero argument list");
                continue;
            }
            Class<?> literal = m.getReturnType();
            this.collectDependencies(Key.get(literal), classesToInstanciate);
        }
        return classesToInstanciate;
    }

    private void collectDependencies(Key<?> current, Set<Key<?>> collected) {
        if (collected.contains(current)) {
            return;
        }
        collected.add(current);
        Set<Key<?>> dependencies = this.getDependencies(current);
        for (Key<?> dependency : dependencies) {
            this.collectDependencies(dependency, collected);
        }
    }

    private Set<Key<?>> collectDependencies(List<Element> elements) {
        final HashSet dependencies = new HashSet();
        for (Element e : elements) {
            e.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    LOGGER.debug("visiting binding " + binding.toString());
                    if (binding instanceof HasDependencies) {
                        HasDependencies deps = (HasDependencies)binding;
                        for (Dependency d : deps.getDependencies()) {
                            DeferredBindingModule.this.collectDependencies(d.getKey(), dependencies);
                        }
                    } else {
                        DeferredBindingModule.this.collectDependencies(binding.getKey(), dependencies);
                        dependencies.addAll(DeferredBindingModule.this.getDependencies(binding.getKey()));
                    }
                    return null;
                }
            });
        }
        return dependencies;
    }

    private Class<Object> generatedAsyncProvider(String className, Key<?> providedKey) {
        CtClass providedCtClass = GwtClassPool.getCtClass(providedKey.getTypeLiteral().getRawType());
        CtClass c = GwtClassPool.get().makeClass(className);
        c.addInterface(GwtClassPool.getCtClass(AsyncProvider.class));
        try {
            ClassFile classFile = c.getClassFile();
            classFile.setVersionToJava5();
            ConstPool constantPool = classFile.getConstPool();
            CtField provider = CtField.make((String)("private " + Provider.class.getName() + " provider;"), (CtClass)c);
            c.addField(provider);
            FieldInfo fieldInfo = provider.getFieldInfo();
            SignatureAttribute signatureAttribute = new SignatureAttribute(fieldInfo.getConstPool(), "Lcom/google/inject/Provider<" + Descriptor.of((CtClass)providedCtClass) + ">;");
            fieldInfo.addAttribute((AttributeInfo)signatureAttribute);
            AnnotationsAttribute attr = new AnnotationsAttribute(constantPool, "RuntimeVisibleAnnotations");
            Annotation a = new Annotation(Inject.class.getName(), constantPool);
            attr.setAnnotation(a);
            provider.getFieldInfo().addAttribute((AttributeInfo)attr);
            CtMethod get = CtMethod.make((String)("public void get(" + AsyncCallback.class.getName() + " callback) { callback.onSuccess(provider.get()); }"), (CtClass)c);
            c.addMethod(get);
            return c.toClass();
        }
        catch (CannotCompileException e) {
            throw new GwtTestGinException("Error while creating AsyncProvider subclass [" + className + "]", e);
        }
    }

    private Class<Object> getAsyncProvider(Key<?> key) {
        Key providedKey = ReflectUtil.getProvidedKey(key);
        String className = providedKey.getTypeLiteral().getRawType().getName() + "AsyncProvider";
        Class<Object> clazz = GENERATED.get(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.generatedAsyncProvider(className, providedKey);
        GENERATED.put(className, clazz);
        return clazz;
    }

    private Set<Key<?>> getDependencies(InjectionPoint point) {
        HashSet dependencies = new HashSet();
        for (Dependency d1 : point.getDependencies()) {
            dependencies.add(d1.getKey());
        }
        return dependencies;
    }

    private Set<Key<?>> getDependencies(Key<?> clazz) {
        HashSet dependencies = new HashSet();
        if (clazz.getTypeLiteral().getRawType().isInterface()) {
            dependencies.add(clazz);
            return dependencies;
        }
        try {
            dependencies.addAll(this.getDependencies(InjectionPoint.forConstructorOf((TypeLiteral)clazz.getTypeLiteral())));
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        for (InjectionPoint point : InjectionPoint.forInstanceMethodsAndFields((TypeLiteral)clazz.getTypeLiteral())) {
            dependencies.addAll(this.getDependencies(point));
        }
        for (InjectionPoint point : InjectionPoint.forStaticMethodsAndFields((TypeLiteral)clazz.getTypeLiteral())) {
            dependencies.addAll(this.getDependencies(point));
        }
        return dependencies;
    }

    private boolean hasAnyGuiceAnnotation(Class<?> toInstanciate) {
        Boolean hasAnyGuiceAnnotation = HAS_INJECTION_ANNOTATION_CACHE.get(toInstanciate);
        if (hasAnyGuiceAnnotation != null) {
            return hasAnyGuiceAnnotation;
        }
        hasAnyGuiceAnnotation = GwtReflectionUtils.getAnnotation(toInstanciate, Singleton.class) != null ? Boolean.valueOf(true) : (GwtReflectionUtils.getAnnotation(toInstanciate, ProvidedBy.class) != null ? Boolean.valueOf(true) : (this.hasInjectAnnotatedConstructor(toInstanciate) ? Boolean.valueOf(true) : Boolean.valueOf(GwtReflectionUtils.getAnnotatedField(toInstanciate, Inject.class).size() > 0)));
        HAS_INJECTION_ANNOTATION_CACHE.put(toInstanciate, hasAnyGuiceAnnotation);
        return hasAnyGuiceAnnotation;
    }

    private boolean hasInjectAnnotatedConstructor(Class<?> toInstanciate) {
        for (Constructor<?> cons : toInstanciate.getDeclaredConstructors()) {
            if (cons.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isAsyncProviderKey(Key<?> key) {
        Type keyType = key.getTypeLiteral().getType();
        return keyType instanceof ParameterizedType && ((ParameterizedType)keyType).getRawType() == AsyncProvider.class;
    }

    private boolean isProviderKey(Key<?> key) {
        Type keyType = key.getTypeLiteral().getType();
        return keyType instanceof ParameterizedType && (((ParameterizedType)keyType).getRawType() == Provider.class || ((ParameterizedType)keyType).getRawType() == Provider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeferredBindingProvider
    implements Provider<Object> {
        private final Class<?> clazzToInstanciate;

        public DeferredBindingProvider(Class<? extends Ginjector> ginInjectorClass, Key<?> key) {
            Class rawType = key.getTypeLiteral().getRawType();
            if (rawType.getName().endsWith("Async")) {
                try {
                    this.clazzToInstanciate = GwtReflectionUtils.getClass(rawType.getName().substring(0, rawType.getName().length() - 5));
                }
                catch (ClassNotFoundException e) {
                    throw new GwtTestPatchException("Error while trying to create a Guice provider for injector '" + ginInjectorClass.getName() + "'", e);
                }
            } else {
                this.clazzToInstanciate = rawType;
            }
        }

        public Object get() {
            return GWT.create(this.clazzToInstanciate);
        }
    }
}

