/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.assertions;

import com.googlecode.gwt.test.assertions.GwtWritableAssertionInfo;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.description.Description;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.error.ShouldBeEqual;
import org.fest.assertions.internal.Failures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GwtGenericAssert<S extends GwtGenericAssert<S, A>, A>
extends AbstractAssert<S, A> {
    protected final GwtWritableAssertionInfo gwtInfo;
    private final Failures failures = Failures.instance();

    protected GwtGenericAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
        this.gwtInfo = new GwtWritableAssertionInfo();
        GwtReflectionUtils.setPrivateFieldValue((Object)this, "info", (Object)this.gwtInfo);
    }

    public S as(String description, Object ... args) {
        return (S)((Object)((GwtGenericAssert)this.describedAs(String.format(description, args))));
    }

    public S withPrefix(String prefix) {
        this.gwtInfo.prefix(prefix);
        return (S)((Object)((GwtGenericAssert)this.myself));
    }

    protected AssertionError failWithMessage(String format, Object ... arguments) {
        GwtWritableAssertionInfo info = new GwtWritableAssertionInfo();
        info.prefix(this.gwtInfo.prefix());
        info.overridingErrorMessage(this.gwtInfo.overridingErrorMessage());
        Description d = this.gwtInfo.superDescription();
        String newDescription = d != null ? d.value() : this.actual.getClass().getSimpleName();
        info.description(newDescription);
        return this.failures.failure((AssertionInfo)info, (ErrorMessageFactory)new BasicErrorMessageFactory(format, arguments));
    }

    protected AssertionError propertyComparisonFailed(String propertyName, Object actual, Object expected) {
        GwtWritableAssertionInfo info = new GwtWritableAssertionInfo();
        info.prefix(this.gwtInfo.prefix());
        info.overridingErrorMessage(this.gwtInfo.overridingErrorMessage());
        Description d = this.gwtInfo.superDescription();
        String newDescription = d != null ? d.value() + " " + propertyName : this.actual.getClass().getSimpleName() + "'s " + propertyName;
        info.description(newDescription);
        return this.failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual((Object)actual, (Object)expected));
    }
}

