/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.assertions;

import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.assertions.GwtGenericAssert;
import com.googlecode.gwt.test.utils.WidgetUtils;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseUIObjectAssert<S extends BaseUIObjectAssert<S, A>, A extends UIObject>
extends GwtGenericAssert<S, A> {
    protected BaseUIObjectAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S doesNotHaveStyle(String ... notExpected) {
        for (String styleName : notExpected) {
            if (!WidgetUtils.hasStyle((UIObject)this.actual, styleName)) continue;
            throw this.failWithMessage("should not have style %s", styleName);
        }
        return (S)((Object)((BaseUIObjectAssert)this.myself));
    }

    public S hasStyle(String ... expected) {
        for (String styleName : expected) {
            if (WidgetUtils.hasStyle((UIObject)this.actual, styleName)) continue;
            throw this.failWithMessage("should have style %s", styleName);
        }
        return (S)((Object)((BaseUIObjectAssert)this.myself));
    }

    public S htmlContains(String sequence) {
        String html;
        String string = html = HasHTML.class.isInstance(this.actual) ? ((HasHTML)this.actual).getHTML() : ((UIObject)this.actual).getElement().getInnerHTML();
        if (html.contains(sequence)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.failWithMessage("actual HTML [%s] does not contains [%s]", html, sequence);
    }

    public S htmlEquals(String expected) {
        String html;
        String string = html = HasHTML.class.isInstance(this.actual) ? ((HasHTML)this.actual).getHTML() : ((UIObject)this.actual).getElement().getInnerHTML();
        if (Objects.areEqual((Object)html, (Object)expected)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.propertyComparisonFailed("HTML", html, expected);
    }

    public S isNotVisible() {
        if (!WidgetUtils.isWidgetVisible((UIObject)this.actual)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.failWithMessage("should not be visible", new Object[0]);
    }

    public S isVisible() {
        if (WidgetUtils.isWidgetVisible((UIObject)this.actual)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.failWithMessage("should be visible", new Object[0]);
    }

    public S styleNameEquals(String expected) {
        String styleName = ((UIObject)this.actual).getStyleName();
        if (Objects.areEqual((Object)styleName, (Object)expected)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.propertyComparisonFailed("styleName", styleName, expected);
    }

    public S stylePrimaryNameEquals(String expected) {
        String stylePrimaryName = ((UIObject)this.actual).getStylePrimaryName();
        if (Objects.areEqual((Object)stylePrimaryName, (Object)expected)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.propertyComparisonFailed("stylePrimaryName", stylePrimaryName, expected);
    }

    public S textContains(String sequence) {
        String text;
        String string = text = HasText.class.isInstance(this.actual) ? ((HasText)this.actual).getText() : ((UIObject)this.actual).getElement().getInnerText();
        if (text.contains(sequence)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.failWithMessage("actual text [%s] does not contains [%s]", text, sequence);
    }

    public S textEquals(String expected) {
        String text;
        String string = text = HasText.class.isInstance(this.actual) ? ((HasText)this.actual).getText() : ((UIObject)this.actual).getElement().getInnerText();
        if (Objects.areEqual((Object)text, (Object)expected)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.propertyComparisonFailed("text", text, expected);
    }

    public S titleContains(String sequence) {
        String title = ((UIObject)this.actual).getTitle();
        if (title.contains(sequence)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.failWithMessage("actual title [%s] does not contains [%s]", title, sequence);
    }

    public S titleEquals(String expected) {
        String title = ((UIObject)this.actual).getTitle();
        if (Objects.areEqual((Object)title, (Object)expected)) {
            return (S)((Object)((BaseUIObjectAssert)this.myself));
        }
        throw this.propertyComparisonFailed("title", title, expected);
    }
}

