/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test;

import com.googlecode.gwt.test.GwtModuleRunnerAdapter;
import com.googlecode.gwt.test.GwtReset;
import com.googlecode.gwt.test.GwtRunner;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.GwtFactory;
import com.googlecode.gwt.test.internal.GwtTestDataHolder;
import com.googlecode.gwt.test.utils.events.Browser;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fest.assertions.api.Fail;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.model.TestClass;

@RunWith(value=GwtRunner.class)
public abstract class GwtTest
extends GwtModuleRunnerAdapter {
    private static final Browser.BrowserErrorHandler FEST_BROWSER_ERROR_HANDLER = new Browser.BrowserErrorHandler(){

        public void onError(String errorMessage) {
            Fail.fail((String)errorMessage);
        }
    };

    @BeforeClass
    public static final void bindClassLoader() {
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)GwtFactory.get().getClassLoader()));
    }

    @AfterClass
    public static final void unbindClassLoader() {
        Thread.currentThread().setContextClassLoader(GwtFactory.get().getClassLoader().getParent());
    }

    public GwtTest() {
        TestClass testClass = new TestClass(this.getClass());
        GwtConfig.get().setupGwtModule(testClass.getJavaClass());
        GwtConfig.get().setupInstance(this);
    }

    @Before
    public final void setUpGwtTest() throws Exception {
        this.setCanDispatchEventsOnDetachedWidgets(true);
        GwtTestDataHolder.get().setCurrentTestFailed(false);
    }

    @After
    public final void tearDownGwtTest() throws Exception {
        GwtReset.get().reset();
        boolean currentTestFailed = GwtTestDataHolder.get().isCurrentTestFailed();
        List<Throwable> throwables = AfterTestCallbackManager.get().triggerCallbacks();
        if (!currentTestFailed && throwables.size() > 0) {
            String error = throwables.size() == 1 ? "One exception thrown during gwt-test-utils cleanup phase : " : throwables.size() + " exceptions thrown during gwt-test-utils cleanup phase. First one is thrown :";
            throw new GwtTestException(error, throwables.get(0));
        }
    }

    protected Test createJUnit4TestAdapter() {
        return new JUnit4TestAdapter(this.getClass());
    }

    protected Browser.BrowserErrorHandler getDefaultBrowserErrorHandler() {
        return FEST_BROWSER_ERROR_HANDLER;
    }
}

