/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test;

import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.user.client.ui.IsWidget;
import com.googlecode.gwt.test.BrowserSimulator;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.GwtLogHandler;
import com.googlecode.gwt.test.GwtModuleRunner;
import com.googlecode.gwt.test.RemoteServiceExecutionHandler;
import com.googlecode.gwt.test.WindowOperationsHandler;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.BrowserSimulatorImpl;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.handlers.GwtTestGWTBridge;
import com.googlecode.gwt.test.internal.i18n.DictionaryUtils;
import com.googlecode.gwt.test.rpc.ServletMockProvider;
import com.googlecode.gwt.test.uibinder.UiObjectTagFactory;
import com.googlecode.gwt.test.utils.events.Browser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GwtModuleRunnerAdapter
implements GwtModuleRunner,
AfterTestCallback {
    private static final String DEFAULT_WAR_DIR = "war/";
    private static final String MAVEN_DEFAULT_RES_DIR = "src/main/resources/";
    private static final String MAVEN_DEFAULT_WEB_DIR = "src/main/webapp/";
    private final BrowserErrorHandlerDelegate browserErrorHandlerDelegate;
    private final BrowserSimulatorImpl browserSimulatorImpl;
    private boolean canDispatchEventsOnDetachedWidgets;
    private final Map<String, String> clientProperties;
    private Locale locale;
    private boolean localStorageSupported = true;
    private GwtLogHandler logHandler;
    private final List<RemoteServiceExecutionHandler> remoteServiceExecutionHandlers = new ArrayList<RemoteServiceExecutionHandler>();
    private ServletMockProvider servletMockProvider;
    private boolean sessionStorageSupported = true;
    private WindowOperationsHandler windowOperationsHandler;

    public GwtModuleRunnerAdapter() {
        this.browserErrorHandlerDelegate = new BrowserErrorHandlerDelegate();
        this.browserSimulatorImpl = BrowserSimulatorImpl.get();
        this.clientProperties = new HashMap<String, String>();
        AfterTestCallbackManager.get().registerRemoveableCallback(this);
    }

    @Override
    public final void addClientProperty(String propertyName, String value) {
        this.clientProperties.put(propertyName, value);
    }

    @Override
    public final void addDictionaryEntries(String dictionaryName, Map<String, String> entries) {
        Dictionary dictionary = Dictionary.getDictionary((String)dictionaryName);
        DictionaryUtils.addEntries(dictionary, entries);
    }

    @Override
    public final void addGwtCreateHandler(GwtCreateHandler gwtCreateHandler) {
        GwtTestGWTBridge.get().addGwtCreateHandler(gwtCreateHandler);
    }

    @Override
    public final void addUiObjectTagFactory(UiObjectTagFactory<? extends IsWidget> factory) {
        GwtConfig.get().getUiObjectTagFactories().add(factory);
    }

    @Override
    public final void afterTest() throws Throwable {
        this.locale = null;
        this.windowOperationsHandler = null;
        this.browserErrorHandlerDelegate.customHandler = null;
        this.servletMockProvider = null;
        this.localStorageSupported = true;
        this.sessionStorageSupported = true;
        this.remoteServiceExecutionHandlers.clear();
    }

    @Override
    public final boolean canDispatchEventsOnDetachedWidgets() {
        return this.canDispatchEventsOnDetachedWidgets;
    }

    @Override
    public boolean ensureDebugId() {
        return false;
    }

    @Override
    public final Browser.BrowserErrorHandler getBrowserErrorHandler() {
        return this.browserErrorHandlerDelegate;
    }

    @Override
    public final String getClientProperty(String propertyName) {
        return this.clientProperties.get(propertyName);
    }

    @Override
    public final Set<String> getClientPropertyNames() {
        return this.clientProperties.keySet();
    }

    @Override
    public final String getHostPagePath() {
        return this.getHostPagePath(GwtConfig.get().getTestedModuleName());
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final GwtLogHandler getLogHandler() {
        return this.logHandler;
    }

    @Override
    public List<RemoteServiceExecutionHandler> getRemoteServiceExecutionHandlers() {
        return Collections.unmodifiableList(this.remoteServiceExecutionHandlers);
    }

    @Override
    public ServletMockProvider getServletMockProvider() {
        return this.servletMockProvider;
    }

    @Override
    public final WindowOperationsHandler getWindowOperationsHandler() {
        return this.windowOperationsHandler;
    }

    @Override
    public boolean isLocalStorageSupported() {
        return this.localStorageSupported;
    }

    @Override
    public boolean isSessionStorageSupported() {
        return this.sessionStorageSupported;
    }

    protected BrowserSimulator getBrowserSimulator() {
        return this.browserSimulatorImpl;
    }

    protected abstract Browser.BrowserErrorHandler getDefaultBrowserErrorHandler();

    protected String getHostPagePath(String moduleFullQualifiedName) {
        String fileSimpleName = moduleFullQualifiedName.substring(moduleFullQualifiedName.lastIndexOf(46) + 1) + ".html";
        String fileRelativePath = DEFAULT_WAR_DIR + fileSimpleName;
        if (new File(fileRelativePath).exists()) {
            return fileRelativePath;
        }
        fileRelativePath = MAVEN_DEFAULT_WEB_DIR + fileSimpleName;
        if (new File(fileRelativePath).exists()) {
            return fileRelativePath;
        }
        String packagePath = moduleFullQualifiedName.substring(0, moduleFullQualifiedName.lastIndexOf(46) + 1).replaceAll("\\.", "/");
        fileRelativePath = MAVEN_DEFAULT_RES_DIR + packagePath + "public/" + fileSimpleName;
        if (new File(fileRelativePath).exists()) {
            return fileRelativePath;
        }
        return null;
    }

    protected final void registerRemoteServiceExecutionHandler(RemoteServiceExecutionHandler remoteServiceExecutionHandler) {
        this.remoteServiceExecutionHandlers.add(remoteServiceExecutionHandler);
    }

    protected final void setBrowserErrorHandler(Browser.BrowserErrorHandler browserErrorHandler) {
        this.browserErrorHandlerDelegate.customHandler = browserErrorHandler;
    }

    protected final void setCanDispatchEventsOnDetachedWidgets(boolean canDispatchEventsOnDetachedWidgets) {
        this.canDispatchEventsOnDetachedWidgets = canDispatchEventsOnDetachedWidgets;
    }

    protected final void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void setLocalStorageSupported(boolean localStorageSupported) {
        this.localStorageSupported = localStorageSupported;
    }

    protected final void setLogHandler(GwtLogHandler logHandler) {
        this.logHandler = logHandler;
    }

    protected final void setServletMockProvider(ServletMockProvider servletMockProvider) {
        this.servletMockProvider = servletMockProvider;
    }

    protected void setSessionStorageSupported(boolean sessionStorageSupported) {
        this.sessionStorageSupported = sessionStorageSupported;
    }

    protected final void setWindowOperationsHandler(WindowOperationsHandler windowOperationsHandler) {
        this.windowOperationsHandler = windowOperationsHandler;
    }

    private final class BrowserErrorHandlerDelegate
    implements Browser.BrowserErrorHandler {
        private Browser.BrowserErrorHandler customHandler;
        private Browser.BrowserErrorHandler defaultHandler;

        private BrowserErrorHandlerDelegate() {
        }

        public void onError(String errorMessage) {
            GwtModuleRunnerAdapter.this.browserSimulatorImpl.clearPendingCommands();
            if (this.customHandler != null) {
                this.customHandler.onError(errorMessage);
            } else {
                this.ensureDefault().onError(errorMessage);
            }
        }

        private Browser.BrowserErrorHandler ensureDefault() {
            if (this.defaultHandler == null) {
                this.defaultHandler = GwtModuleRunnerAdapter.this.getDefaultBrowserErrorHandler();
                if (this.defaultHandler == null) {
                    throw new GwtTestConfigurationException("You have to provide a non null instance of " + Browser.BrowserErrorHandler.class.getSimpleName() + " when overriding " + GwtModuleRunnerAdapter.class.getName() + ".getDefaultBrowserErrorHandler()");
                }
            }
            return this.defaultHandler;
        }
    }
}

