/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.ServletDefinition;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;

public class ServletDefinitionReader {
    private static final TypeLiteral<ServletDefinition> SERVLET_DEFS = TypeLiteral.get(ServletDefinition.class);
    private final Injector injector;
    private final Map<String, Key<? extends HttpServlet>> mapUriToServletKeys = new HashMap<String, Key<? extends HttpServlet>>();
    private final Map<String, HttpServlet> mapUriToServlets = new HashMap<String, HttpServlet>();

    public ServletDefinitionReader(Injector injector) {
        this.injector = injector;
        this.collectServletDefinitions(injector);
    }

    public HttpServlet getServletForPath(String uri) {
        for (Map.Entry<String, Key<? extends HttpServlet>> entry : this.mapUriToServletKeys.entrySet()) {
            if (!entry.getKey().matches(uri)) continue;
            if (!this.mapUriToServlets.containsKey(entry.getKey())) {
                try {
                    this.mapUriToServlets.put(entry.getKey(), (HttpServlet)this.injector.getInstance(entry.getValue()));
                }
                catch (Throwable t) {
                    throw new GwtTestConfigurationException("cannot instantiate servlet", t);
                }
            }
            return this.mapUriToServlets.get(entry.getKey());
        }
        throw new GwtTestConfigurationException("Cannot find servlet mapped to: " + uri);
    }

    private void collectServletDefinitions(Injector injector) {
        for (Binding entry : injector.findBindingsByType(SERVLET_DEFS)) {
            ServletDefinition def = (ServletDefinition)entry.getProvider().get();
            Key key = (Key)GwtReflectionUtils.getPrivateFieldValue((Object)def, "servletKey");
            this.mapUriToServletKeys.put(def.getPattern(), (Key<? extends HttpServlet>)key);
        }
    }
}

