/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xydra.csv.ExcelLimitException;
import org.xydra.csv.ICell;
import org.xydra.csv.IReadableRow;
import org.xydra.csv.IRow;
import org.xydra.csv.IRowInsertionHandler;
import org.xydra.csv.IRowVisitor;
import org.xydra.csv.ISparseTable;
import org.xydra.csv.RowFilter;
import org.xydra.csv.WrongDatatypeException;
import org.xydra.csv.impl.memory.Row;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.iterator.ReadOnlyIterator;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class SparseTable
implements ISparseTable {
    public static final int EXCEL_MAX_COLS = 255;
    public static final int EXCEL_MAX_ROWS = 65535;
    private static Logger log = LoggerFactory.getLogger(SparseTable.class);
    boolean aggregateStrings = true;
    Set<String> columnNames;
    boolean restrictToExcelSize = false;
    private IRowInsertionHandler rowInsertionHandler;
    private final List<String> rowNames = new LinkedList<String>();
    private final Map<String, Row> table = new TreeMap<String, Row>();

    private void insertRow(String rowName, Row row) {
        if (this.rowCount() == 65535) {
            log.warn("Adding the 65535th row - that is Excels limit");
            if (this.restrictToExcelSize) {
                throw new ExcelLimitException("Row limit reached");
            }
        }
        if (this.table.containsKey(rowName)) {
            assert (this.rowNames.contains(rowName));
            Row existingRow = this.getOrCreateRow(rowName, false);
            for (Map.Entry<String, ICell> entry : row.entrySet()) {
                try {
                    existingRow.setValue(entry.getKey(), entry.getValue().getValue(), true);
                }
                catch (IllegalStateException ex) {
                    throw new IllegalStateException("Table contains already a row named '" + rowName + "' and for key '" + entry.getKey() + "' there was already a value.", ex);
                }
            }
        } else {
            assert (!this.rowNames.contains(rowName));
            this.rowNames.add(rowName);
            this.table.put(rowName, row);
        }
    }

    protected Iterable<String> rowNamesIterable() {
        return this.rowNames;
    }

    protected Iterator<String> subIterator(int startRow, int endRow) {
        return this.rowNames.subList(startRow, endRow).iterator();
    }

    @Override
    public Iterator<Row> iterator() {
        return new ReadOnlyIterator(this.table.values().iterator());
    }

    @Override
    public Iterator<Row> getDataRows() {
        Iterator<Row> it = this.table.values().iterator();
        if (it.hasNext()) {
            it.next();
            return new ReadOnlyIterator(it);
        }
        return Iterators.none();
    }

    @Override
    public Row getHeaderRow() {
        return this.table.values().iterator().next();
    }

    public SparseTable() {
        this.columnNames = new TreeSet<String>();
    }

    public SparseTable(boolean maintainColumnInsertionOrder) {
        this.columnNames = maintainColumnInsertionOrder ? new LinkedHashSet<String>() : new TreeSet<String>();
    }

    public void addAll(SparseTable other) {
        for (Map.Entry<String, Row> entry : other.table.entrySet()) {
            Row thisRow = this.getOrCreateRow(entry.getKey(), true);
            for (Map.Entry<String, ICell> rowEntry : entry.getValue().entrySet()) {
                thisRow.setValue(rowEntry.getKey(), rowEntry.getValue().getValue());
            }
        }
    }

    @Override
    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    protected void addRow(String rowName, Row row) {
        boolean insert = true;
        if (this.rowInsertionHandler != null) {
            insert &= this.rowInsertionHandler.beforeRowInsertion(row);
        }
        if (insert) {
            this.insertRow(rowName, row);
        }
    }

    @Override
    public void aggregate(String[] keyColumnNames) {
        HashMap<String, Row> compoundKeys2row = new HashMap<String, Row>(this.rowCount());
        Iterator<Row> rowIt = this.table.values().iterator();
        long processed = 0L;
        long aggregated = 0L;
        while (rowIt.hasNext()) {
            Row row = rowIt.next();
            StringBuffer compoundKeyBuffer = new StringBuffer(100);
            for (String keyColumnName : keyColumnNames) {
                String value = row.getValue(keyColumnName);
                if (value == null) continue;
                compoundKeyBuffer.append(value);
            }
            String compoundKey = compoundKeyBuffer.toString();
            if (compoundKeys2row.containsKey(compoundKey)) {
                IRow masterRow = (IRow)compoundKeys2row.get(compoundKey);
                masterRow.aggregate(row, keyColumnNames);
                ++aggregated;
                rowIt.remove();
                this.rowNames.remove(row.getKey());
            } else {
                compoundKeys2row.put(compoundKey, row);
            }
            if (++processed % 1000L != 0L) continue;
            log.info("Aggregate processed " + processed + " rows, aggregated " + aggregated);
        }
        log.info(this.rowCount() + " rows with aggregated data remain");
    }

    void appendString(String row, String column, String s, int maximalFieldLength) {
        Row r = this.getOrCreateRow(row, true);
        ICell c = r.getOrCreateCell(column, true);
        c.appendString(s, maximalFieldLength);
    }

    @Override
    public void clear() {
        this.rowNames.clear();
        this.table.clear();
    }

    protected int colCount() {
        return this.columnNames.size();
    }

    @Override
    public ISparseTable dropColumn(String columnName, String value) {
        SparseTable target = new SparseTable();
        for (String rowName : this.rowNames) {
            Row sourceRow = this.getOrCreateRow(rowName, false);
            if (sourceRow.getValue(columnName).equals(value)) continue;
            IRow targetRow = target.getOrCreateRow(rowName, true);
            for (String colName : sourceRow.getColumnNames()) {
                targetRow.setValue(colName, sourceRow.getValue(colName), true);
            }
        }
        return target;
    }

    @Override
    public ISparseTable filter(String key, String value) {
        SparseTable target = new SparseTable();
        for (String rowName : this.rowNames) {
            Row sourceRow = this.getOrCreateRow(rowName, false);
            if (!sourceRow.getValue(key).equals(value)) continue;
            IRow targetRow = target.getOrCreateRow(rowName, true);
            for (String colName : sourceRow.getColumnNames()) {
                targetRow.setValue(colName, sourceRow.getValue(colName), true);
            }
        }
        return target;
    }

    @Override
    public Set<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Row getOrCreateRow(String rowName, boolean create) {
        Row row = this.table.get(rowName);
        if (row == null) {
            assert (!this.rowNames.contains(rowName));
            if (create) {
                row = new Row(rowName, this);
                this.insertRow(rowName, row);
            }
        }
        return row;
    }

    @Override
    public boolean getParamAggregateStrings() {
        return this.aggregateStrings;
    }

    @Override
    public boolean getParamRestrictToExcelSize() {
        return this.restrictToExcelSize;
    }

    @Override
    public String getValue(String row, String column) {
        Row r = this.getOrCreateRow(row, false);
        if (r == null) {
            return null;
        }
        ICell c = r.getOrCreateCell(column, false);
        if (c == null) {
            return null;
        }
        return c.getValue();
    }

    @Override
    public void incrementValue(String row, String column, int increment) throws WrongDatatypeException {
        Row r = this.getOrCreateRow(row, true);
        ICell c = r.getOrCreateCell(column, true);
        c.incrementValue(increment);
    }

    @Override
    public void removeRowsMatching(RowFilter rowFilter) {
        Iterator<Map.Entry<String, Row>> it = this.table.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Row> entry = it.next();
            String rowName = entry.getKey();
            if (!rowFilter.matches(entry.getValue())) continue;
            it.remove();
            this.rowNames.remove(rowName);
        }
    }

    @Override
    public int rowCount() {
        return this.table.size();
    }

    @Override
    public void setParamAggregateStrings(boolean aggregateStrings) {
        this.aggregateStrings = aggregateStrings;
    }

    @Override
    public void setParamRestrictToExcelSize(boolean b) {
        this.restrictToExcelSize = b;
    }

    public void setRowInsertionHandler(IRowInsertionHandler rowInsertionHandler) {
        this.rowInsertionHandler = rowInsertionHandler;
    }

    @Override
    public void setValueInitial(String rowName, String columnName, String value) throws IllegalStateException {
        Row row = this.getOrCreateRow(rowName, true);
        row.setValue(columnName, value, true);
    }

    @Override
    public void setValueInitial(String rowName, String columnName, long value) throws IllegalStateException {
        Row row = this.getOrCreateRow(rowName, true);
        row.setValue(columnName, value, true);
    }

    public Map<String, SparseTable> split(String colName) {
        HashMap<String, SparseTable> map = new HashMap<String, SparseTable>();
        for (String rowName : this.rowNames) {
            Row row = this.getOrCreateRow(rowName, false);
            String currentValue = row.getValue(colName);
            SparseTable table = (SparseTable)map.get(currentValue);
            if (table == null) {
                table = new SparseTable();
                map.put(currentValue, table);
            }
            Row copyRow = table.getOrCreateRow(rowName, true);
            copyRow.addAll(row);
        }
        return map;
    }

    @Override
    public void visitRows(IRowVisitor rowVisitor) {
        for (IRow row : this) {
            rowVisitor.visit(row);
        }
    }

    @Override
    public void handleRow(String rowName, IReadableRow readableRow) {
        Row row = new Row(rowName, this);
        for (Map.Entry<String, ICell> entry : readableRow.entrySet()) {
            row.setValue(entry.getKey(), entry.getValue().getValue());
        }
        this.addRow(rowName, row);
    }

    @Override
    public Iterable<String> getColumnNamesSorted() {
        return this.columnNames;
    }

    @Override
    public void handleHeaderRow(Collection<String> columnNames) {
        this.columnNames.addAll(columnNames);
    }
}

