/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xydra.csv.ExcelLimitException;
import org.xydra.csv.ICsvTable;
import org.xydra.csv.ICsvTableFactory;
import org.xydra.csv.IReadableRow;
import org.xydra.csv.IRow;
import org.xydra.csv.impl.memory.CsvCodec;
import org.xydra.csv.impl.memory.CsvCoreTable;
import org.xydra.csv.impl.memory.CsvReader;
import org.xydra.csv.impl.memory.Row;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CsvTable
extends CsvCoreTable
implements ICsvTable,
ICsvTableFactory {
    private static Logger log = LoggerFactory.getLogger(CsvTable.class);
    private boolean oversizeWarning = false;

    public CsvTable(boolean maintainColumnInsertionOrder) {
        super(maintainColumnInsertionOrder);
    }

    public CsvTable() {
    }

    @Override
    public void dump() throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        this.writeTo(writer);
        ((Writer)writer).flush();
    }

    @Override
    public void dumpToLaTeX() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        this.toLaTeX(osw);
    }

    @Override
    public void readFrom(File f) throws IOException {
        this.readFrom(f, this.defaultEncoding);
    }

    @Override
    public void readFrom(File f, String encoding) throws IOException {
        log.info("Reading CSV table from " + f.getAbsolutePath() + " Before: " + this.rowCount() + " rows and " + this.colCount() + " columns");
        FileInputStream fos = new FileInputStream(f);
        InputStreamReader reader = new InputStreamReader((InputStream)fos, Charset.forName(encoding));
        this.readFrom(reader, true);
        ((Reader)reader).close();
        this.columnNames.remove("NULL");
        this.columnNames.remove("ROW");
    }

    @Override
    public void readFrom(Reader r, boolean create) throws IOException {
        CsvReader csvReader = new CsvReader(r, this.readMaxRows);
        List<String> columnNames = csvReader.readHeaders();
        assert (this.columnNames != null);
        this.columnNames.addAll(columnNames);
        IReadableRow row = csvReader.readDataRow();
        while (row != null) {
            Row tableRow = this.getOrCreateRow(row.getKey(), true);
            tableRow.addAll(row);
            row = csvReader.readDataRow();
        }
    }

    @Override
    public void toLaTeX(Writer w) throws IOException {
        HashMap<String, Integer> colName2maxLength = new HashMap<String, Integer>();
        for (IRow row : this) {
            for (String colName : this.columnNames) {
                int oldmax = colName2maxLength.get(colName) == null ? 0 : (Integer)colName2maxLength.get(colName);
                String value = row.getValue(colName);
                int newmax = Math.max(oldmax, value.length());
                colName2maxLength.put(colName, newmax);
            }
        }
        w.write("\\begin{tabular}{|");
        for (int i = 0; i < this.columnNames.size(); ++i) {
            w.write("l|");
        }
        w.write("}\n");
        w.write("\\hline\n");
        String lastColumnName2 = null;
        for (String lastColumnName2 : this.columnNames) {
        }
        for (String colName : this.columnNames) {
            w.write(CsvTable.latexEncode(colName, (Integer)colName2maxLength.get(colName)));
            if (colName.equals(lastColumnName2)) {
                w.write(" \\\\\n");
                continue;
            }
            w.write(" & ");
        }
        w.write("\\hline\n");
        for (String rowName : this.rowNamesIterable()) {
            Row row = this.getOrCreateRow(rowName, false);
            for (String colName : this.columnNames) {
                w.write(CsvTable.latexEncode(row.getValue(colName), (Integer)colName2maxLength.get(colName)));
                if (colName.equals(lastColumnName2)) {
                    w.write(" \\\\\n");
                    continue;
                }
                w.write(" & ");
            }
        }
        w.write("\\hline\n");
        w.write("\\end{tabular}\n");
        w.flush();
    }

    @Override
    public void writeTo(File f) throws FileNotFoundException {
        this.writeTo(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File f, boolean append) throws FileNotFoundException {
        FileOutputStream fos;
        log.info("Writing CSV table to " + f.getAbsolutePath());
        try {
            fos = new FileOutputStream(f, append);
        }
        catch (FileNotFoundException e) {
            File f2 = new File(f.getAbsolutePath() + "-COULD-NOT-" + (append ? "APPEND" : "OVERWRITE"));
            fos = new FileOutputStream(f2);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.defaultEncoding));
        try {
            if (!append && this.splitWhenWritingLargeFiles) {
                log.info("Will write as " + (this.rowCount() / 65535 + 1) + " file(s)");
                int startRow = 0;
                int endRow = Math.min(65535, this.rowCount());
                this.writeTo(writer, startRow, endRow);
                int fileNumber = 1;
                for (int writtenRows = endRow - startRow; writtenRows < this.rowCount(); writtenRows += endRow - startRow) {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    startRow += 65535;
                    endRow = Math.min(endRow + 65535, this.rowCount());
                    File f1 = new File(f.getAbsolutePath() + "-part-" + fileNumber);
                    fos = new FileOutputStream(f1);
                    writer = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.defaultEncoding));
                    ++fileNumber;
                    this.writeTo(writer, startRow, endRow);
                }
            } else {
                this.writeTo(writer);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
        }
        finally {
            try {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e1) {
                log.warn("", (Throwable)e1);
            }
        }
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        log.info("Writing " + this.rowCount() + " rows with " + this.columnNames.size() + " columns");
        this.writeTo(w, 0, this.rowCount());
    }

    @Override
    public void writeTo(Writer w, int startRow, int endRow) throws IOException, ExcelLimitException {
        if (!this.oversizeWarning && endRow - startRow > 65535) {
            log.warn("Exceeding Excels limit of 65535 rows - older versions of Excel cannot read it");
            this.oversizeWarning = true;
        }
        log.debug("Writing rows " + startRow + " to " + endRow + " of " + this.rowCount() + " rows with " + this.colCount() + " columns");
        int writtenRows = 0;
        w.write(65279);
        CsvTable.writeHeaderRow(w, this.columnNames);
        ++writtenRows;
        Iterator<String> rowIt = super.subIterator(startRow, endRow);
        while (rowIt.hasNext() && (!this.restrictToExcelSize || writtenRows < 65535)) {
            String rowName = rowIt.next();
            Row row = this.getOrCreateRow(rowName, false);
            if (row == null) {
                log.warn("Encountered null-row named '" + rowName + "', skipping.");
                continue;
            }
            CsvTable.writeRow(w, this.columnNames, rowName, row);
            ++writtenRows;
        }
    }

    public static void writeTable(Writer w, List<String> columNames, Iterator<IReadableRow> rowIt) throws IOException {
        if (!rowIt.hasNext()) {
            log.warn("No rows in rowIt, writing empty table");
            return;
        }
        IReadableRow firstRow = rowIt.next();
        int writtenRows = 0;
        CsvTable.writeHeaderRow(w, columNames);
        ++writtenRows;
        while (writtenRows < 65535) {
            String rowName = "" + writtenRows;
            CsvTable.writeRow(w, columNames, rowName, firstRow);
            ++writtenRows;
        }
        while (rowIt.hasNext() && writtenRows < 65535) {
            IReadableRow row = rowIt.next();
            String rowName = "" + writtenRows;
            CsvTable.writeRow(w, columNames, rowName, row);
            ++writtenRows;
        }
    }

    public static void writeHeaderRow(Writer w, Collection<String> columnNames) throws IOException {
        w.write(CsvCodec.excelEncode("ROW"));
        Iterator<String> colIt = columnNames.iterator();
        int writtenCols = 0;
        boolean warnedOnColumnNumber = false;
        while (colIt.hasNext()) {
            String columnName = colIt.next();
            w.write(";" + CsvCodec.excelEncode(columnName));
            if (warnedOnColumnNumber || ++writtenCols != 255) continue;
            log.warn("Reached Excels limit of 255 columns. Writing more anyway.");
            warnedOnColumnNumber = true;
        }
        w.write(";\n");
    }

    public static void writeRow(Writer w, Collection<String> columnNames, String rowName, IReadableRow row) throws IOException {
        assert (row != null);
        w.write(CsvCodec.excelEncode(rowName));
        Iterator<String> colIt = columnNames.iterator();
        int writtenCols = 0;
        boolean warnedOnColumnNumber = false;
        while (colIt.hasNext()) {
            String columnName = colIt.next();
            w.write(";" + CsvCodec.excelEncode(row.getValue(columnName)));
            if (warnedOnColumnNumber || ++writtenCols != 255) continue;
            log.warn("Reached Excels limit of 255 columns. Writing more anyway.");
            warnedOnColumnNumber = true;
        }
        w.write(";\n");
    }

    @Override
    public ICsvTable createTable() {
        return new CsvTable();
    }

    @Override
    public ICsvTable createTable(boolean maintainColumnInsertionOrder) {
        return new CsvTable(maintainColumnInsertionOrder);
    }
}

