/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xydra.csv.IReadableRow;
import org.xydra.csv.impl.memory.CsvCodec;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.SingleRow;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CsvReader {
    private static Logger log = LoggerFactory.getLogger(CsvTable.class);
    private final int readMaxRows;
    private final BufferedReader br;
    private List<String> colNames;
    private long lineNumber;

    public CsvReader(Reader reader, int readMaxRows) {
        this.br = new BufferedReader(reader);
        this.readMaxRows = readMaxRows;
    }

    public List<String> readHeaders() throws IllegalStateException, IOException, IllegalArgumentException {
        String line = this.br.readLine();
        if (line == null) {
            throw new IllegalArgumentException("CSV file has no content, not even headers");
        }
        String[] headers = CsvCodec.splitAtUnquotedSemicolon(line);
        if (headers.length < 1) {
            throw new IllegalArgumentException("Found no first column");
        }
        this.colNames = new ArrayList<String>();
        for (String s : headers) {
            String decoded = CsvCodec.excelDecode(s);
            this.colNames.add(decoded == null ? "NULL" : decoded);
        }
        this.lineNumber = 1L;
        return this.colNames;
    }

    public IReadableRow readDataRow() throws IllegalStateException, IOException {
        String line = this.br.readLine();
        SingleRow row = null;
        if (line != null && (this.readMaxRows == -1 || this.lineNumber < (long)this.readMaxRows)) {
            String[] datas = CsvCodec.splitAtUnquotedSemicolon(line);
            if (this.colNames.size() != datas.length) {
                throw new IllegalArgumentException("Line " + this.lineNumber + ": Header length (" + this.colNames.size() + ") is different from data length (" + datas.length + ")");
            }
            String rowName = CsvCodec.excelDecode(datas[0]);
            row = new SingleRow(rowName);
            for (int i = 1; i < this.colNames.size(); ++i) {
                try {
                    String value = CsvCodec.excelDecode(datas[i]);
                    String colName = CsvCodec.excelDecode(this.colNames.get(i));
                    row.setValue(colName, value, true);
                    continue;
                }
                catch (IllegalStateException e) {
                    throw new IllegalArgumentException("Line " + this.lineNumber + "> Could not parse '" + line + "'", e);
                }
            }
            if (this.lineNumber % 10000L == 0L) {
                log.info("Parsed " + this.lineNumber + " lines...");
            }
        }
        return row;
    }
}

