/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv;

import org.xydra.csv.WrongDatatypeException;

public class TypeHandler {
    public static double asDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            String usVersion = value.replace(",", ".");
            try {
                return Double.parseDouble(usVersion);
            }
            catch (NumberFormatException e2) {
                throw new WrongDatatypeException("Content was '" + value + "'. Could not parse as double. Even tried to parse as '" + usVersion + "'", e);
            }
        }
    }

    public static long asLong(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new WrongDatatypeException("Content was '" + value + "'. Could not parse as long.", e);
        }
    }

    Type fromString(String s) {
        try {
            long l = Long.parseLong(s);
            return new LONG(l);
        }
        catch (NumberFormatException e) {
            return new ERROR();
        }
    }

    public static interface Type {
        public String toValueString();
    }

    public static class LONG
    implements Type {
        private final long value;

        public LONG(long l) {
            this.value = l;
        }

        @Override
        public String toValueString() {
            return "" + this.value;
        }
    }

    public static class ERROR
    implements Type {
        @Override
        public String toValueString() {
            return "##";
        }
    }
}

