/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.Renderer;
import com.google.caliper.bridge.ShouldContinueMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StartupAnnounceMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.model.Measurement;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.UUID;

public final class WorkerEventLog {
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final Renderer<CaliperControlLogMessage> controlLogMessageRenderer;
    private final Gson parser;

    @Inject
    WorkerEventLog(BufferedWriter writer, BufferedReader reader, Renderer<CaliperControlLogMessage> controlLogMessageRenderer, Gson parser) {
        this.writer = writer;
        this.reader = reader;
        this.controlLogMessageRenderer = controlLogMessageRenderer;
        this.parser = parser;
    }

    public void notifyWorkerStarted(UUID trialId) throws IOException {
        this.println(this.parser.toJson((Object)new StartupAnnounceMessage(trialId)));
        this.println(this.controlLogMessageRenderer.render(new VmPropertiesLogMessage()));
        this.writer.flush();
    }

    public void notifyWarmupPhaseStarting() throws IOException {
        this.printlnAndFlush("Warmup starting.");
    }

    public void notifyMeasurementPhaseStarting() throws IOException {
        this.printlnAndFlush("Measurement phase starting.");
    }

    public void notifyMeasurementStarting() throws IOException {
        this.println("About to measure.");
        this.println(this.controlLogMessageRenderer.render(new StartMeasurementLogMessage()));
        this.writer.flush();
    }

    public boolean notifyMeasurementEnding(Measurement measurement) throws IOException {
        return this.notifyMeasurementEnding((Iterable<Measurement>)ImmutableList.of((Object)measurement));
    }

    public boolean notifyMeasurementEnding(Iterable<Measurement> measurements) throws IOException {
        this.println(this.controlLogMessageRenderer.render(new StopMeasurementLogMessage(measurements)));
        for (Measurement measurement : measurements) {
            this.println(String.format("I got a result! %s: %f%s%n", measurement.description(), measurement.value().magnitude() / measurement.weight(), measurement.value().unit()));
        }
        this.writer.flush();
        return this.shouldKeepMeasuring();
    }

    public void notifyFailure(Exception e) throws IOException {
        this.printlnAndFlush(this.controlLogMessageRenderer.render(new FailureLogMessage(e)));
    }

    private boolean shouldKeepMeasuring() throws IOException {
        return ((ShouldContinueMessage)this.parser.fromJson(this.reader.readLine(), ShouldContinueMessage.class)).shouldContinue();
    }

    private void println(String str) throws IOException {
        this.writer.write(str);
        this.writer.write(10);
    }

    private void printlnAndFlush(String str) throws IOException {
        this.println(str);
        this.writer.flush();
    }
}

