/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.model.Measurement;
import com.google.caliper.runner.Running;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.lang.reflect.Method;

public abstract class Worker {
    @Inject
    @Running.BeforeExperimentMethods
    private ImmutableSet<Method> beforeExperimentMethods;
    @Inject
    @Running.AfterExperimentMethods
    private ImmutableSet<Method> afterExperimentMethods;
    protected final Method benchmarkMethod;
    protected final Object benchmark;

    protected Worker(Object benchmark, Method method) {
        this.benchmark = benchmark;
        this.benchmarkMethod = method;
    }

    final void setUpBenchmark() throws Exception {
        for (Method method : this.beforeExperimentMethods) {
            method.invoke(this.benchmark, new Object[0]);
        }
    }

    public void bootstrap() throws Exception {
    }

    public void preMeasure() throws Exception {
    }

    public void postMeasure() throws Exception {
    }

    public abstract Iterable<Measurement> measure() throws Exception;

    final void tearDownBenchmark() throws Exception {
        for (Method method : this.afterExperimentMethods) {
            method.invoke(this.benchmark, new Object[0]);
        }
    }
}

