/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.model.Measurement;
import com.google.caliper.runner.Running;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.AllocationStats;
import com.google.caliper.worker.Worker;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Random;

public final class MicrobenchmarkAllocationWorker
extends Worker {
    private static final int WARMUP_REPS = 10;
    private static final int MAX_REPS = 100;
    private final Random random;
    private final AllocationRecorder recorder;

    @Inject
    MicrobenchmarkAllocationWorker(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, AllocationRecorder recorder, Random random) {
        super(benchmark, method);
        this.random = random;
        this.recorder = recorder;
    }

    @Override
    public void bootstrap() throws Exception {
        this.measureAllocations(this.benchmark, this.benchmarkMethod, 10);
    }

    @Override
    public Iterable<Measurement> measure() throws Exception {
        AllocationStats baseline = this.measureAllocations(this.benchmark, this.benchmarkMethod, 0);
        int measurementReps = this.random.nextInt(100) + 1;
        AllocationStats measurement = this.measureAllocations(this.benchmark, this.benchmarkMethod, measurementReps);
        return measurement.minus(baseline).toMeasurements();
    }

    private AllocationStats measureAllocations(Object benchmark, Method method, int reps) throws Exception {
        Object[] args = new Object[]{reps};
        this.recorder.startRecording();
        method.invoke(benchmark, args);
        return this.recorder.stopRecording(reps);
    }
}

