/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.VmOptionLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.model.VmSpec;
import com.google.caliper.runner.ProxyWorkerException;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

final class VmDataCollectingVisitor
extends AbstractLogMessageVisitor {
    private final ImmutableMap.Builder<String, String> vmOptionsBuilder = ImmutableMap.builder();
    private Optional<ImmutableMap<String, String>> vmProperties = Optional.absent();
    static final Predicate<String> PROPERTIES_TO_RETAIN = new Predicate<String>(){

        public boolean apply(String input) {
            return input.startsWith("java.vm") || input.startsWith("java.runtime") || input.equals("java.version") || input.equals("java.vendor") || input.equals("sun.reflect.noInflation") || input.equals("sun.reflect.inflationThreshold");
        }
    };

    VmDataCollectingVisitor() {
    }

    VmSpec vmSpec() {
        ImmutableMap options = this.vmOptionsBuilder.build();
        Preconditions.checkState((!options.isEmpty() ? 1 : 0) != 0);
        return new VmSpec.Builder().addAllProperties((Map)this.vmProperties.get()).addAllOptions((Map<String, String>)options).build();
    }

    @Override
    public void visit(FailureLogMessage logMessage) {
        throw new ProxyWorkerException(logMessage.stackTrace());
    }

    @Override
    public void visit(VmOptionLogMessage logMessage) {
        this.vmOptionsBuilder.put((Object)logMessage.name(), (Object)logMessage.value());
    }

    @Override
    public void visit(VmPropertiesLogMessage logMessage) {
        this.vmProperties = Optional.of((Object)ImmutableMap.copyOf((Map)Maps.filterKeys(logMessage.properties(), PROPERTIES_TO_RETAIN)));
    }
}

