/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.Host;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Run;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.runner.Experiment;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.ServerSocketService;
import com.google.caliper.runner.TrialFactory;
import com.google.caliper.runner.TrialId;
import com.google.caliper.runner.TrialScoped;
import com.google.caliper.runner.TrialScopes;
import com.google.caliper.runner.VmDataCollectingVisitor;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Map;
import java.util.UUID;

final class TrialModule
extends AbstractModule {
    TrialModule() {
    }

    protected void configure() {
        this.install(TrialScopes.module());
    }

    @TrialScoped
    @Provides
    BenchmarkSpec provideBenchmarkSpec(Experiment experiment) {
        return new BenchmarkSpec.Builder().className(experiment.instrumentation().benchmarkMethod().getDeclaringClass().getName()).methodName(experiment.instrumentation().benchmarkMethod().getName()).addAllParameters((Map<String, String>)experiment.userParameters()).build();
    }

    @Provides
    @TrialScoped
    ListenableFuture<ServerSocketService.OpenedSocket> provideTrialSocket(@TrialId UUID trialId, ServerSocketService serverSocketService) {
        return serverSocketService.getConnection(trialId);
    }

    @Provides
    Instrument.MeasurementCollectingVisitor provideMeasurementCollectingVisitor(Experiment experiment) {
        return experiment.instrumentation().getMeasurementCollectingVisitor();
    }

    @Provides
    TrialFactory provideTrialFactory(final @TrialId UUID trialId, final Run run, final Host host, final Experiment experiment, final BenchmarkSpec benchmarkSpec) {
        return new TrialFactory(){

            @Override
            public Trial newTrial(VmDataCollectingVisitor dataCollectingVisitor, Instrument.MeasurementCollectingVisitor measurementCollectingVisitor) {
                Preconditions.checkState((boolean)measurementCollectingVisitor.isDoneCollecting());
                return new Trial.Builder(trialId).run(run).instrumentSpec(experiment.instrumentation().instrument().getSpec()).scenario(new Scenario.Builder().host(host).vmSpec(dataCollectingVisitor.vmSpec()).benchmarkSpec(benchmarkSpec)).addAllMeasurements((Iterable<Measurement>)measurementCollectingVisitor.getMeasurements()).build();
            }
        };
    }
}

