/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.Host;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

final class EnvironmentGetter {
    EnvironmentGetter() {
    }

    Host getHost() {
        return new Host.Builder().addAllProperies(this.getProperties()).build();
    }

    private Map<String, String> getProperties() {
        TreeMap propertyMap = Maps.newTreeMap();
        ImmutableMap sysProps = Maps.fromProperties((Properties)System.getProperties());
        String version = (String)sysProps.get("java.version");
        String alternateVersion = (String)sysProps.get("java.runtime.version");
        if (alternateVersion != null && alternateVersion.length() > version.length()) {
            version = alternateVersion;
        }
        propertyMap.put("host.availableProcessors", Integer.toString(Runtime.getRuntime().availableProcessors()));
        String osName = (String)sysProps.get("os.name");
        propertyMap.put("os.name", osName);
        propertyMap.put("os.version", sysProps.get("os.version"));
        propertyMap.put("os.arch", sysProps.get("os.arch"));
        if (osName.equals("Linux")) {
            this.getLinuxEnvironment(propertyMap);
        }
        return propertyMap;
    }

    private void getLinuxEnvironment(Map<String, String> propertyMap) {
        Multimap<String, String> cpuInfo = EnvironmentGetter.propertiesFromLinuxFile("/proc/cpuinfo");
        propertyMap.put("host.cpus", Integer.toString(cpuInfo.get((Object)"processor").size()));
        String s = "cpu cores";
        propertyMap.put("host.cpu.cores", EnvironmentGetter.describe(cpuInfo, s));
        propertyMap.put("host.cpu.names", EnvironmentGetter.describe(cpuInfo, "model name"));
        propertyMap.put("host.cpu.cachesize", EnvironmentGetter.describe(cpuInfo, "cache size"));
        Multimap<String, String> memInfo = EnvironmentGetter.propertiesFromLinuxFile("/proc/meminfo");
        propertyMap.put("host.memory.physical", memInfo.get((Object)"MemTotal").toString());
        propertyMap.put("host.memory.swap", memInfo.get((Object)"SwapTotal").toString());
    }

    private static String describe(Multimap<String, String> cpuInfo, String s) {
        Collection strings = cpuInfo.get((Object)s);
        return strings.size() == 1 ? (String)strings.iterator().next() : ImmutableMultiset.copyOf((Iterable)strings).toString();
    }

    private static Multimap<String, String> propertiesFromLinuxFile(String file) {
        try {
            List lines = Files.readLines((File)new File(file), (Charset)Charset.defaultCharset());
            ImmutableMultimap.Builder result = ImmutableMultimap.builder();
            for (String line : lines) {
                String[] parts = line.split("\\s*\\:\\s*", 2);
                if (parts.length != 2) continue;
                result.put((Object)parts[0], (Object)parts[1]);
            }
            return result.build();
        }
        catch (IOException e) {
            return ImmutableMultimap.of();
        }
    }
}

