/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.Running;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import java.lang.reflect.Method;

public final class BenchmarkClassModule
extends AbstractModule {
    private final Class<?> benchmarkClassObject;

    public BenchmarkClassModule(Class<?> benchmarkClassObject) {
        this.benchmarkClassObject = benchmarkClassObject;
    }

    protected void configure() {
        this.bind(new Key<Class<?>>(Running.BenchmarkClass.class){}).toInstance(this.benchmarkClassObject);
    }

    @Provides
    BenchmarkClass provideBenchmarkClass() throws InvalidBenchmarkException {
        return BenchmarkClass.forClass(this.benchmarkClassObject);
    }

    @Provides
    @Running.BeforeExperimentMethods
    ImmutableSet<Method> provideBeforeExperimentMethods(BenchmarkClass benchmarkClass) {
        return benchmarkClass.beforeExperimentMethods();
    }

    @Provides
    @Running.AfterExperimentMethods
    ImmutableSet<Method> provideAfterExperimentMethods(BenchmarkClass benchmarkClass) {
        return benchmarkClass.afterExperimentMethods();
    }
}

