/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.options;

import com.google.caliper.util.DisplayUsageException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Primitives;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

final class CommandLineParser<T> {
    private final InjectionMap injectionMap;
    private T injectee;
    private final List<PendingInjection> pendingInjections = Lists.newArrayList();

    public static <T> CommandLineParser<T> forClass(Class<? extends T> c) {
        return new CommandLineParser<T>(c);
    }

    private CommandLineParser(Class<? extends T> c) {
        this.injectionMap = InjectionMap.forClass(c);
    }

    public void parseAndInject(String[] args, T injectee) throws InvalidCommandException {
        String arg;
        this.injectee = injectee;
        this.pendingInjections.clear();
        UnmodifiableIterator argsIter = Iterators.forArray((Object[])args);
        ImmutableList.Builder builder = ImmutableList.builder();
        while (argsIter.hasNext() && !(arg = (String)argsIter.next()).equals("--")) {
            if (arg.startsWith("--")) {
                this.parseLongOption(arg, (Iterator<String>)argsIter);
                continue;
            }
            if (arg.startsWith("-")) {
                this.parseShortOptions(arg, (Iterator<String>)argsIter);
                continue;
            }
            builder.add((Object)arg);
        }
        for (PendingInjection pi : this.pendingInjections) {
            pi.injectableOption.inject(pi.value, injectee);
        }
        ImmutableList leftovers = builder.addAll((Iterator)argsIter).build();
        CommandLineParser.invokeMethod(injectee, this.injectionMap.leftoversMethod, leftovers);
    }

    private static Object convert(Parser<?> parser, String valueText) throws InvalidCommandException {
        Object value;
        try {
            value = parser.parse(valueText);
        }
        catch (ParseException e) {
            throw new InvalidCommandException("wrong datatype: " + e.getMessage(), new Object[0]);
        }
        return value;
    }

    private void parseLongOption(String arg, Iterator<String> args) throws InvalidCommandException {
        String name = arg.replaceFirst("^--no-", "--");
        String value = null;
        int equalsIndex = name.indexOf(61);
        if (equalsIndex != -1) {
            value = name.substring(equalsIndex + 1);
            name = name.substring(0, equalsIndex);
        }
        InjectableOption injectable = this.injectionMap.getInjectableOption(name);
        if (value == null) {
            value = injectable.isBoolean() ? Boolean.toString(!arg.startsWith("--no-")) : this.grabNextValue(args, name);
        }
        this.injectNowOrLater(injectable, value);
    }

    private void injectNowOrLater(InjectableOption injectable, String value) throws InvalidCommandException {
        if (injectable.delayedInjection()) {
            this.pendingInjections.add(new PendingInjection(injectable, value));
        } else {
            injectable.inject(value, this.injectee);
        }
    }

    private void parseShortOptions(String arg, Iterator<String> args) throws InvalidCommandException {
        for (int i = 1; i < arg.length(); ++i) {
            String value;
            String name = "-" + arg.charAt(i);
            InjectableOption injectable = this.injectionMap.getInjectableOption(name);
            if (injectable.isBoolean()) {
                value = "true";
            } else if (i + 1 < arg.length()) {
                value = arg.substring(i + 1);
                i = arg.length() - 1;
            } else {
                value = this.grabNextValue(args, name);
            }
            this.injectNowOrLater(injectable, value);
        }
    }

    private static void invokeMethod(Object injectee, Method method, Object value) throws InvalidCommandException {
        try {
            method.invoke(injectee, value);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, InvalidCommandException.class);
            throw new RuntimeException(e);
        }
    }

    private String grabNextValue(Iterator<String> args, String name) throws InvalidCommandException {
        if (args.hasNext()) {
            return args.next();
        }
        throw new InvalidCommandException("option '" + name + "' requires an argument", new Object[0]);
    }

    private static boolean isStaticOrAbstract(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers);
    }

    private static class PendingInjection {
        InjectableOption injectableOption;
        String value;

        private PendingInjection(InjectableOption injectableOption, String value) {
            this.injectableOption = injectableOption;
            this.value = value;
        }
    }

    private static class MethodOption
    extends InjectableOption {
        private Method method;
        private boolean isBoolean;
        private Parser<?> parser;

        private static InjectableOption create(Method method) {
            Preconditions.checkArgument((!CommandLineParser.isStaticOrAbstract(method) ? 1 : 0) != 0, (Object)"@Option methods cannot be static or abstract");
            Class<?>[] classes = method.getParameterTypes();
            Preconditions.checkArgument((classes.length == 1 ? 1 : 0) != 0, (Object)("Method does not have exactly one argument: " + method));
            return new MethodOption(method, classes[0]);
        }

        private MethodOption(Method method, Class<?> c) {
            this.method = method;
            this.isBoolean = c == Boolean.TYPE || c == Boolean.class;
            try {
                this.parser = Parsers.conventionalParser(Primitives.wrap(c));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No suitable String-conversion method");
            }
            method.setAccessible(true);
        }

        @Override
        boolean isBoolean() {
            return this.isBoolean;
        }

        @Override
        boolean delayedInjection() {
            return true;
        }

        @Override
        void inject(String valueText, Object injectee) throws InvalidCommandException {
            CommandLineParser.invokeMethod(injectee, this.method, CommandLineParser.convert(this.parser, valueText));
        }
    }

    private static class FieldOption
    extends InjectableOption {
        private Field field;
        private boolean isBoolean;
        private Parser<?> parser;

        private static InjectableOption create(Field field) {
            field.setAccessible(true);
            Type type = field.getGenericType();
            if (type instanceof Class) {
                return new FieldOption(field, (Class)type);
            }
            throw new IllegalArgumentException("can't inject parameterized types etc.");
        }

        private FieldOption(Field field, Class<?> c) {
            this.field = field;
            this.isBoolean = c == Boolean.TYPE || c == Boolean.class;
            try {
                this.parser = Parsers.conventionalParser(Primitives.wrap(c));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No suitable String-conversion method");
            }
        }

        @Override
        boolean isBoolean() {
            return this.isBoolean;
        }

        @Override
        void inject(String valueText, Object injectee) throws InvalidCommandException {
            Object value = CommandLineParser.convert(this.parser, valueText);
            try {
                this.field.set(injectee, value);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }

    private static class InjectionMap {
        final ImmutableMap<String, InjectableOption> optionMap;
        final Method leftoversMethod;

        public static InjectionMap forClass(Class<?> injectedClass) {
            InjectableOption injectable;
            Option option;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            InjectableOption helpOption = new InjectableOption(){

                @Override
                boolean isBoolean() {
                    return true;
                }

                @Override
                void inject(String valueText, Object injectee) throws DisplayUsageException {
                    throw new DisplayUsageException();
                }
            };
            builder.put((Object)"-h", (Object)helpOption);
            builder.put((Object)"--help", (Object)helpOption);
            AccessibleObject leftoverMethod = null;
            for (Field field : injectedClass.getDeclaredFields()) {
                Preconditions.checkArgument((!field.isAnnotationPresent(Leftovers.class) ? 1 : 0) != 0, (Object)"Sorry, @Leftovers only works for methods at present");
                option = field.getAnnotation(Option.class);
                if (option == null) continue;
                injectable = FieldOption.create(field);
                for (String optionName : option.value()) {
                    builder.put((Object)optionName, (Object)injectable);
                }
            }
            for (AccessibleObject accessibleObject : injectedClass.getDeclaredMethods()) {
                if (accessibleObject.isAnnotationPresent(Leftovers.class)) {
                    Preconditions.checkArgument((!CommandLineParser.isStaticOrAbstract((Method)accessibleObject) ? 1 : 0) != 0, (Object)"@Leftovers method cannot be static or abstract");
                    Preconditions.checkArgument((!accessibleObject.isAnnotationPresent(Option.class) ? 1 : 0) != 0, (Object)"method has both @Option and @Leftovers");
                    Preconditions.checkArgument((leftoverMethod == null ? 1 : 0) != 0, (Object)"Two methods have @Leftovers");
                    ((Method)accessibleObject).setAccessible(true);
                    leftoverMethod = accessibleObject;
                }
                if ((option = ((Method)accessibleObject).getAnnotation(Option.class)) == null) continue;
                injectable = MethodOption.create((Method)accessibleObject);
                for (String optionName : option.value()) {
                    builder.put((Object)optionName, (Object)injectable);
                }
            }
            ImmutableMap optionMap = builder.build();
            return new InjectionMap((ImmutableMap<String, InjectableOption>)optionMap, (Method)leftoverMethod);
        }

        InjectionMap(ImmutableMap<String, InjectableOption> optionMap, Method leftoversMethod) {
            this.optionMap = optionMap;
            this.leftoversMethod = leftoversMethod;
        }

        InjectableOption getInjectableOption(String optionName) throws InvalidCommandException {
            InjectableOption injectable = (InjectableOption)this.optionMap.get((Object)optionName);
            if (injectable == null) {
                throw new InvalidCommandException("Invalid option: %s", optionName);
            }
            return injectable;
        }
    }

    private static abstract class InjectableOption {
        private InjectableOption() {
        }

        abstract boolean isBoolean();

        abstract void inject(String var1, Object var2) throws InvalidCommandException;

        boolean delayedInjection() {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Leftovers {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Option {
        public String[] value();
    }
}

