/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.model.Run;
import com.google.caliper.options.CaliperDirectory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
final class LoggingConfigLoader {
    private static final Logger logger = Logger.getLogger(LoggingConfigLoader.class.getName());
    private final File caliperDirectory;
    private final LogManager logManager;
    private final Run run;

    @Inject
    LoggingConfigLoader(@CaliperDirectory File caliperDirectory, LogManager logManager, Run run) {
        this.caliperDirectory = caliperDirectory;
        this.logManager = logManager;
        this.run = run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    void loadLoggingConfig() {
        File loggingPropertiesFile = new File(this.caliperDirectory, "logging.properties");
        if (loggingPropertiesFile.isFile()) {
            Closer closer = Closer.create();
            FileInputStream fis = null;
            try {
                fis = (FileInputStream)closer.register((Closeable)new FileInputStream(loggingPropertiesFile));
                this.logManager.readConfiguration(fis);
            }
            catch (SecurityException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
            catch (IOException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
            finally {
                try {
                    closer.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "could not close " + loggingPropertiesFile, e);
                }
            }
            logger.info(String.format("Using logging configuration at %s", loggingPropertiesFile));
        } else {
            try {
                this.maybeLoadDefaultLogConfiguration(LogManager.getLogManager());
            }
            catch (SecurityException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
            catch (IOException e) {
                LoggingConfigLoader.logConfigurationException(e);
            }
        }
    }

    @VisibleForTesting
    void maybeLoadDefaultLogConfiguration(LogManager logManager) throws SecurityException, IOException {
        logManager.reset();
        File logDirectory = new File(this.caliperDirectory, "log");
        logDirectory.mkdirs();
        FileHandler fileHandler = new FileHandler(String.format("%s%c%s.%s.log", logDirectory.getAbsolutePath(), Character.valueOf(File.separatorChar), ISODateTimeFormat.basicDateTimeNoMillis().print((ReadableInstant)this.run.startTime()), this.run.id()));
        fileHandler.setEncoding(Charsets.UTF_8.name());
        fileHandler.setFormatter(new SimpleFormatter());
        Logger globalLogger = logManager.getLogger("");
        globalLogger.addHandler(fileHandler);
    }

    private static void logConfigurationException(Exception e) {
        logger.log(Level.WARNING, "Could not apply the logging configuration", e);
    }
}

