/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XIntegerListValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.DemoModelUtil;
import org.xydra.core.model.XModel;
import org.xydra.core.model.XRepository;
import org.xydra.core.model.impl.memory.MemoryRepository;
import org.xydra.core.serialize.SerializedValue;
import org.xydra.core.serialize.ValueDeSerializer;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.json.JsonSerializer;
import org.xydra.csv.IRow;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.index.query.Pair;

public class CsvSerialisation {
    private static final String TYPE_SUFFIX = "__type";

    public static int writeToCsv(XReadableModel model, Writer w) throws IOException {
        CsvTable table = CsvSerialisation.toCsvTable(model);
        table.writeTo(w);
        return table.rowCount();
    }

    public static CsvTable toCsvTable(XReadableModel model) throws IOException {
        CsvTable table = new CsvTable(false);
        for (XId oid : model) {
            Row row = table.getOrCreateRow(oid.toString(), true);
            XReadableObject xo = model.getObject(oid);
            for (XId fid : xo) {
                String csvValueStr;
                String csvTypeStr;
                XReadableField xf = xo.getField(fid);
                assert (xf != null);
                XValue xvalue = xf.getValue();
                if (xvalue == null) {
                    csvTypeStr = ValueType.Boolean.name();
                    csvValueStr = "fieldPresent";
                } else {
                    Pair pair = ValueDeSerializer.toStringPair((XValue)xvalue);
                    csvTypeStr = (String)pair.getFirst();
                    csvValueStr = (String)pair.getSecond();
                }
                row.setValue(fid.toString() + TYPE_SUFFIX, csvTypeStr, true);
                row.setValue(fid.toString(), csvValueStr, true);
            }
        }
        return table;
    }

    public static int readFromCsv(Reader r, XWritableModel model) throws IOException {
        CsvTable table = new CsvTable();
        table.readFrom(r, true);
        for (IRow row : table) {
            String oidStr = row.getKey();
            XId oid = Base.toId((String)oidStr);
            XWritableObject xo = model.createObject(oid);
            for (String col : row.getColumnNames()) {
                String valueStr;
                if (col.endsWith(TYPE_SUFFIX) || (valueStr = row.getValue(col)) == null) continue;
                String typeStr = row.getValue(col + TYPE_SUFFIX);
                try {
                    XValue value = ValueDeSerializer.fromStrings((String)typeStr, (String)valueStr);
                    XId fid = Base.toId((String)col);
                    XWritableField field = xo.createField(fid);
                    field.setValue(value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not parse " + row + " as Xydra data", e);
                }
            }
        }
        return table.rowCount();
    }

    protected static String serialize(XValue value) {
        JsonSerializer serializer = new JsonSerializer();
        XydraOut out = serializer.create();
        out.enableWhitespace(false, false);
        SerializedValue.serialize((XValue)value, (XydraOut)out);
        String data = out.getData();
        return data;
    }

    protected static XValue deserialize(String data) {
        JsonParser parser = new JsonParser();
        XydraElement xydraElement = parser.parse(data);
        XValue value = SerializedValue.toValue((XydraElement)xydraElement);
        return value;
    }

    public static void main(String[] args) throws IOException {
        XIntegerListValue test = XV.toIntegerListValue(Arrays.asList(11, 12, 13));
        String test2 = CsvSerialisation.serialize((XValue)test);
        XValue test3 = CsvSerialisation.deserialize(test2);
        System.out.println(test);
        System.out.println(test2);
        System.out.println(test3);
        MemoryRepository repo = new MemoryRepository(Base.toId((String)"actor"), "secret", Base.toId((String)"repo"));
        DemoModelUtil.addPhonebookModel((XRepository)repo);
        XModel model = repo.getModel(DemoModelUtil.PHONEBOOK_ID);
        File f = new File("./phonebook.csv");
        FileOutputStream fout = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fout, "utf-8");
        CsvSerialisation.writeToCsv((XReadableModel)model, w);
        ((Writer)w).close();
        FileInputStream fin = new FileInputStream(f);
        InputStreamReader in = new InputStreamReader((InputStream)fin, "utf-8");
        SimpleModel model2 = new SimpleModel(Base.toAddress((String)"/repo1/model1"));
        CsvSerialisation.readFromCsv(in, (XWritableModel)model2);
        DumpUtilsBase.dump((String)"model2", (XReadableModel)model2);
    }
}

