/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.xgae;

import com.google.appengine.api.datastore.Entity;
import com.sonicmetrics.gaeserver.impl.GaeUtils;
import java.util.Iterator;
import org.xydra.base.BaseRuntime;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XStateReadableField;
import org.xydra.base.rmof.XStateReadableObject;
import org.xydra.base.value.XValue;
import org.xydra.core.serialize.ValueDeSerializer;
import org.xydra.index.iterator.AbstractFilteringIterator;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.TransformingIterator;
import org.xydra.index.query.Pair;

public class GaeStateReadableObject
implements XStateReadableObject {
    public static final String PREFIX_VALUE = "v_";
    public static final String PREFIX_TYPE = "t_";
    public static final String TYPE_NONE = "none";
    protected Entity gaeEntity;
    protected final XId objectId;
    protected final XId modelId;
    protected final XId repoId;

    protected static Pair<String, String> readField(Entity gaeEntity, XId fieldId) {
        String gaePropType = (String)gaeEntity.getProperty(GaeStateReadableObject.id2propKeyForXydraType(fieldId));
        Object gaePropValueObject = gaeEntity.getProperty(GaeStateReadableObject.id2propKey(fieldId));
        String gaePropValueString = null;
        if (gaePropValueObject != null) {
            gaePropValueString = GaeUtils.fromGaePropertyValue((Object)gaePropValueObject);
        }
        return new Pair((Object)gaePropType, (Object)gaePropValueString);
    }

    public static String id2propKeyForXydraType(XId fieldId) {
        return PREFIX_TYPE + fieldId.toString();
    }

    public GaeStateReadableObject(XId repoId, XId modelId, XId objectId, Entity gaeEntity) {
        this.repoId = repoId;
        this.modelId = modelId;
        this.objectId = objectId;
        this.gaeEntity = gaeEntity;
    }

    public XAddress getAddress() {
        return BaseRuntime.getIDProvider().fromComponents(null, this.modelId, this.objectId, null);
    }

    public GaeStateReadableField getField(XId fieldId) {
        Object gaeProp = this.gaeEntity.getProperty(GaeStateReadableObject.id2propKey(fieldId));
        if (gaeProp == null) {
            return null;
        }
        return new GaeStateReadableField(fieldId);
    }

    public XId getId() {
        return this.objectId;
    }

    public XType getType() {
        return XType.XOBJECT;
    }

    public boolean hasField(XId fieldId) {
        return this.gaeEntity.hasProperty(GaeStateReadableObject.id2propKey(fieldId));
    }

    public boolean isEmpty() {
        return this.gaeEntity.getProperties().isEmpty();
    }

    public Iterator<XId> iterator() {
        Iterator gaePropertyKeyNamesIt = this.gaeEntity.getProperties().keySet().iterator();
        AbstractFilteringIterator<String> gaeTypePropertyKeyNamesIt = new AbstractFilteringIterator<String>(gaePropertyKeyNamesIt){

            protected boolean matchesFilter(String key) {
                return GaeStateReadableObject.this.isTypePropertyKey(key);
            }
        };
        return new TransformingIterator((Iterator)gaeTypePropertyKeyNamesIt, (ITransformer)new ITransformer<String, XId>(){

            public XId transform(String in) {
                return GaeStateReadableObject.propKey2id(in);
            }
        });
    }

    protected boolean isTypePropertyKey(String key) {
        return key.startsWith(PREFIX_TYPE);
    }

    protected static XId propKey2id(String propKey) {
        return BaseRuntime.getIDProvider().fromString(propKey.substring(PREFIX_VALUE.length()));
    }

    public void read() {
    }

    protected static String id2propKey(XId fieldId) {
        return PREFIX_VALUE + fieldId.toString();
    }

    protected class GaeStateReadableField
    implements XStateReadableField {
        protected final XId fieldId;

        public GaeStateReadableField(XId fieldId) {
            this.fieldId = fieldId;
        }

        public XAddress getAddress() {
            return BaseRuntime.getIDProvider().fromComponents(GaeStateReadableObject.this.repoId, GaeStateReadableObject.this.modelId, GaeStateReadableObject.this.objectId, this.fieldId);
        }

        public XId getId() {
            return this.fieldId;
        }

        public XType getType() {
            return XType.XFIELD;
        }

        public XValue getValue() {
            Pair<String, String> type_json = GaeStateReadableObject.readField(GaeStateReadableObject.this.gaeEntity, this.fieldId);
            XValue value = ValueDeSerializer.fromStrings((String)((String)type_json.getFirst()), (String)((String)type_json.getSecond()));
            return value;
        }

        public boolean isEmpty() {
            return this.getValue() == null;
        }
    }
}

