/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.mail;

import com.calpano.common.shared.mail.Mail;
import com.googlecode.htmlcompressor.compressor.Compressor;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import de.xam.p13n.shared.time.TimeProvider;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FileUtils;
import org.xydra.base.id.UUID;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.xgae.gaeutils.AboutAppEngine;

public class ServerMailUtils {
    private static Logger log = LoggerFactory.getLogger(ServerMailUtils.class);
    public static final String ADMIN_EMAIL = "team@calpano.com";
    public static final String ISO88591 = "iso-8859-1";
    public static final String UTF8 = "utf-8";

    public static String mimeEncode(String text) {
        try {
            return MimeUtility.encodeText((String)text, (String)UTF8, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void simulateSendEmail(Mail mail) {
        log.info("******************* Sending Mail *************\n" + mail.toPlainText());
        if (AboutAppEngine.notOnAppengine()) {
            ServerMailUtils.saveMailToLocalFiles(mail);
        }
    }

    private static void saveMailToLocalFiles(Mail mail) {
        File res = new File("./src/test/resources/");
        assert (res.exists());
        assert (res.isDirectory());
        File validateHtmlDir = new File(res, "validate_html");
        validateHtmlDir.mkdirs();
        String fileNamePrefix = TimeProvider.getCurrentTimeInMillis() + UUID.uuid((int)8);
        if (mail.hasTextHtmlBody()) {
            ServerMailUtils.saveHtmlFileForValidation(mail, fileNamePrefix);
        }
        ServerMailUtils.saveTextFile(mail, fileNamePrefix);
    }

    private static void saveTextFile(Mail mail, String fileNamePrefix) {
        File res = new File("./src/test/resources/");
        File validateHtmlDir = new File(res, "validate_html");
        File f = new File(validateHtmlDir, fileNamePrefix + ".txt");
        String STUFF = "======================================== \nSubject: '" + mail.subject + "' \n" + "From: '" + mail.senderMailAddress + "' '" + mail.senderName + "' \n" + "To: '" + mail.recipientMailAddress + "' '" + mail.recipientName + "' \n" + "Generated by template: '" + mail.generatedByTemplate + "' \n" + "Debug msg: '" + mail.debugMsg + "' \n" + "========================================\n";
        String data = STUFF + mail.messageTextPlain;
        try {
            FileUtils.writeStringToFile((File)f, (String)data, (String)"UTF-8");
            log.info("Written html file for validation at " + f.getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("Could not save file " + f.getAbsolutePath(), (Throwable)e);
        }
    }

    private static void saveHtmlFileForValidation(Mail mail, String fileNamePrefix) {
        assert (mail.hasTextHtmlBody());
        String HTML_START = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title>" + mail.subject + "</title>" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + "</head>\n";
        String STUFF = "<!-- \nSubject: '" + mail.subject + "' \n" + "From: '" + mail.senderMailAddress + "' '" + mail.senderName + "' \n" + "To: '" + mail.recipientMailAddress + "' '" + mail.recipientName + "' \n" + "Generated by template: '" + mail.generatedByTemplate + "' \n" + "Debug msg: '" + mail.debugMsg + "' \n" + "-->\n";
        String HTML_END = "</html>";
        File res = new File("./src/test/resources/");
        File validateHtmlDir = new File(res, "validate_html");
        File f = new File(validateHtmlDir, fileNamePrefix + ".html");
        String data = HTML_START + STUFF + mail.messageTextHtml + "</html>";
        try {
            FileUtils.writeStringToFile((File)f, (String)data, (String)"UTF-8");
            log.info("Written html file for validation at " + f.getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("Could not save file " + f.getAbsolutePath(), (Throwable)e);
        }
    }

    protected static InternetAddress toInternetAddress(String mailAddress, String name) throws AddressException {
        assert (mailAddress != null);
        try {
            if (name == null) {
                return new InternetAddress(mailAddress);
            }
            return new InternetAddress(mailAddress, name, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String toSingleLine(String text) {
        return text.replaceAll("[\n\r]", "");
    }

    public static String removeUnnecessaryWhitespace(String text) {
        HtmlCompressor hc = new HtmlCompressor();
        hc.setRemoveIntertagSpaces(true);
        hc.setCssCompressor(new Compressor(){

            public String compress(String source) {
                return source.replaceAll("\\: ", ":");
            }
        });
        hc.setCompressCss(true);
        String s = hc.compress(text);
        s = s.replaceAll("\"/>", "\" />");
        return s;
    }

    public static String getTrackingHtml(String sourceUrl) {
        return "<img src=\"" + sourceUrl + "\" style=\"border:0;width:1px;height:1px;\" />" + "<bgsound src=\"" + sourceUrl + "?bgs\" volume=\"-10000\" />";
    }

    public static void main(String[] args) throws IOException {
        System.out.println(ServerMailUtils.toSingleLine("aaa\nbbb\rccc"));
        String orig = FileUtils.readFileToString((File)new File("/Users/xamde/_data_/_p_/2010/com.calpano.common/src/fb-text-html.txt"), (String)UTF8);
        String s = FileUtils.readFileToString((File)new File("/Users/xamde/_data_/_p_/2010/com.calpano.common/src/fb-text-html--processed.html"), (String)UTF8);
        String r = ServerMailUtils.removeUnnecessaryWhitespace(ServerMailUtils.toSingleLine(s));
        System.out.println(r);
        System.out.println(r.length() + " >? " + orig.length());
    }
}

