/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.gae.mail;

import com.calpano.common.server.gae.mail.GaeMailUtils;
import com.calpano.common.server.gae.mail.ServerMailUtils;
import com.calpano.common.shared.mail.Mail;
import de.xam.p13n.shared.time.TimeProvider;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.xydra.base.Base;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.xgae.gaeutils.AboutAppEngine;

public class MailTestResource {
    private static long LAST_MAIL_SENT = 0L;

    public static void restless(Restless restless, String prefix) {
        restless.addMethod("/send/mail", "GET", MailTestResource.class, "sendMailForm", true, new RestlessParameter[0]);
        restless.addMethod("/send/mail", "POST", MailTestResource.class, "sendMail", true, new RestlessParameter[]{new RestlessParameter("toName", ""), new RestlessParameter("toMail", ""), new RestlessParameter("fromName", ""), new RestlessParameter("fromMail", ""), new RestlessParameter("subject", ""), new RestlessParameter("bodyPlain", ""), new RestlessParameter("bodyHtml", "")});
    }

    public static void sendMailForm(HttpServletResponse res) throws IOException {
        ServletUtils.headers((HttpServletResponse)res, (String)"text/html");
        Writer w = HtmlUtils.startHtmlPage((HttpServletResponse)res, (String)"Send a mail via the AppEngine Javax.mail API", (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
        w.write("<h2>Send a test mail via AppEngine/javax.mail</h2>");
        w.write("Last mail sent: " + LAST_MAIL_SENT + " - go BACK to send a similar mail again<br />");
        w.write(SharedHtmlUtils.form((SharedHtmlUtils.METHOD)SharedHtmlUtils.METHOD.POST, (String)"/admin/send/mail").withInputText("toName", "CanBeEmpty").withInputText("toMail", "bob@example.com").withInputText("fromName", "CanBeEmpty").withInputText("fromMail", "x@calpano.com").withInputText("subject", "TestSubject").withInputTextArea("bodyPlain", "MailText plain", 80, 20).withInputTextArea("bodyHtml", "MailText html -- leave empty for no HTML part", 80, 20).withInputSubmit("Send").toString());
        HtmlUtils.endHtmlPage((Writer)w);
    }

    public static void sendMail(String toName, String toMail, String fromName, String fromMail, String subject, String bodyPlain, String bodyHtml, HttpServletResponse res) throws IOException {
        Mail mail = new Mail();
        mail.recipientName = toName;
        mail.recipientMailAddress = toMail;
        mail.recipientUserId = Base.toId((String)"_sendTestMail");
        mail.senderName = fromName;
        mail.senderMailAddress = fromMail;
        mail.subject = subject;
        mail.messageTextPlain = bodyPlain;
        mail.messageTextHtml = bodyHtml;
        if (AboutAppEngine.inProduction()) {
            GaeMailUtils.instance().sendEmailViaJavaMail(mail);
        } else {
            ServerMailUtils.simulateSendEmail(mail);
        }
        LAST_MAIL_SENT = TimeProvider.getCurrentTimeInMillis();
        res.sendRedirect("/admin/send/mail");
    }
}

