/*
 * Decompiled with CFR 0.152.
 */
package de.xam.kfacet;

import de.xam.kfacet.IFacet;
import de.xam.mybase.model.names.IdManager;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KFacets {
    private static final Logger log = LoggerFactory.getLogger(KFacets.class);
    private static final String NAMESPACE_PREFIX_FACET = "facet";
    private static Map<String, IFacet> MAP = new HashMap<String, IFacet>();

    public static void stop(String name) {
        IFacet facet = MAP.get(name);
        if (facet != null) {
            facet.stop();
        }
    }

    public static void start(String name) throws IOException {
        IFacet facet = MAP.get(name);
        if (facet != null) {
            facet.start();
        }
    }

    public static void startFacets() {
        for (IFacet facet : MAP.values()) {
            if (!facet.getServiceState().mayStart()) continue;
            facet.start();
            while (facet.getServiceState().isStarting()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static IFacet getFacet(String name) {
        IFacet facet = MAP.get(name);
        if (facet == null) {
            throw new IllegalStateException("Facet '" + name + "' should have been registered.");
        }
        return facet;
    }

    public static void stopAllFacets() {
        for (IFacet facet : MAP.values()) {
            facet.stop();
        }
    }

    public static void waitUntilAllStopped() {
        boolean someAreActive = true;
        while (someAreActive) {
            someAreActive = false;
            for (IFacet facet : MAP.values()) {
                if (!facet.getServiceState().isActive()) continue;
                someAreActive = true;
                try {
                    log.info("Facet " + facet.getLabel() + " stops slowly");
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void waitUntilAllRun() {
        boolean someAreInactive = true;
        while (someAreInactive) {
            someAreInactive = false;
            for (IFacet facet : KFacets.facets()) {
                if (!facet.getServiceState().isInactive()) continue;
                someAreInactive = true;
                try {
                    log.info("Facet " + facet.getLabel() + " starts slowly");
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void registerFacet(IFacet facet) {
        MAP.put(facet.getLabel(), facet);
    }

    public static Collection<IFacet> facets() {
        return MAP.values();
    }

    public static XId getFacetId(IFacet facet) {
        return IdManager.toFastRawId((String)("facet-" + facet.getLabel()));
    }
}

