/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import sun.security.util.Debug;
import sun.security.util.PendingException;
import sun.security.util.ResourcesMgr;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private AccessControlContext creatorAcc = null;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS = new Class[0];
    private int moduleIndex = 0;
    private LoginException firstError = null;
    private LoginException firstRequiredError = null;
    private boolean success = false;
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String string) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.creatorAcc == null) {
            securityManager.checkPermission(new AuthPermission("createLoginContext." + string));
        }
        if (string == null) {
            throw new LoginException(ResourcesMgr.getString("Invalid.null.input.name"));
        }
        if (this.config == null) {
            this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

                @Override
                public Configuration run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(string)) == null) {
            if (securityManager != null && this.creatorAcc == null) {
                securityManager.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(OTHER)) == null) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("No.LoginModules.configured.for.name"));
                Object[] objectArray = new Object[]{string};
                throw new LoginException(messageFormat.format(objectArray));
            }
        }
        this.moduleStack = new ModuleInfo[appConfigurationEntryArray.length];
        for (int i = 0; i < appConfigurationEntryArray.length; ++i) {
            this.moduleStack[i] = new ModuleInfo(new AppConfigurationEntry(appConfigurationEntryArray[i].getLoginModuleName(), appConfigurationEntryArray[i].getControlFlag(), appConfigurationEntryArray[i].getOptions()), null);
        }
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return classLoader;
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader classLoader = this.contextClassLoader;
            this.callbackHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                @Override
                public CallbackHandler run() throws Exception {
                    String string = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (string == null || string.length() == 0) {
                        return null;
                    }
                    Class<CallbackHandler> clazz = Class.forName(string, true, classLoader).asSubclass(CallbackHandler.class);
                    return clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new LoginException(privilegedActionException.getException().toString());
        }
        if (this.callbackHandler != null && this.creatorAcc == null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String string) throws LoginException {
        this.init(string);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this.init(string);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.Subject.provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.init(string);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        this.config = configuration;
        if (configuration != null) {
            this.creatorAcc = AccessController.getContext();
        }
        this.init(string);
        if (subject != null) {
            this.subject = subject;
            this.subjectProvided = true;
        }
        if (callbackHandler == null) {
            this.loadDefaultCallbackHandler();
        } else {
            this.callbackHandler = this.creatorAcc == null ? new SecureCallbackHandler(AccessController.getContext(), callbackHandler) : callbackHandler;
        }
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokePriv(LOGIN_METHOD);
            this.invokePriv(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException loginException) {
            try {
                this.invokePriv(ABORT_METHOD);
            }
            catch (LoginException loginException2) {
                throw loginException;
            }
            throw loginException;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException(ResourcesMgr.getString("null.subject.logout.called.before.login"));
        }
        this.invokePriv(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void clearState() {
        this.moduleIndex = 0;
        this.firstError = null;
        this.firstRequiredError = null;
        this.success = false;
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
        this.clearState();
        LoginException loginException3 = loginException != null ? loginException : loginException2;
        throw loginException3;
    }

    private void invokePriv(final String string) throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws LoginException {
                    LoginContext.this.invoke(string);
                    return null;
                }
            }, this.creatorAcc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void invoke(String string) throws LoginException {
        int n = this.moduleIndex;
        while (n < this.moduleStack.length) {
            block38: {
                Object object;
                Object object2;
                try {
                    int n2 = 0;
                    object2 = null;
                    if (this.moduleStack[n].module != null) {
                        object2 = this.moduleStack[n].module.getClass().getMethods();
                    } else {
                        object = Class.forName(this.moduleStack[n].entry.getLoginModuleName(), true, this.contextClassLoader);
                        Constructor constructor = ((Class)object).getConstructor(PARAMS);
                        Object[] objectArray = new Object[]{};
                        this.moduleStack[n].module = constructor.newInstance(objectArray);
                        object2 = this.moduleStack[n].module.getClass().getMethods();
                        for (n2 = 0; n2 < ((Object)object2).length && !((Method)object2[n2]).getName().equals(INIT_METHOD); ++n2) {
                        }
                        Object[] objectArray2 = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[n].entry.getOptions()};
                        ((Method)object2[n2]).invoke(this.moduleStack[n].module, objectArray2);
                    }
                    for (n2 = 0; n2 < ((Method[])object2).length && !((Method)object2[n2]).getName().equals(string); ++n2) {
                    }
                    object = new Object[0];
                    boolean bl = (Boolean)((Method)object2[n2]).invoke(this.moduleStack[n].module, (Object[])object);
                    if (bl) {
                        if (!string.equals(ABORT_METHOD) && !string.equals(LOGOUT_METHOD) && this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && this.firstRequiredError == null) {
                            this.clearState();
                            if (debug != null) {
                                debug.println(string + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(string + " success");
                        }
                        this.success = true;
                    } else if (debug != null) {
                        debug.println(string + " ignored");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object2 = new MessageFormat(ResourcesMgr.getString("unable.to.instantiate.LoginModule.module.because.it.does.not.provide.a.no.argument.constructor"));
                    object = new Object[]{this.moduleStack[n].entry.getLoginModuleName()};
                    this.throwException(null, new LoginException(((Format)object2).format(object)));
                }
                catch (InstantiationException instantiationException) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.instantiate.LoginModule.") + instantiationException.getMessage()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.find.LoginModule.class.") + classNotFoundException.getMessage()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.access.LoginModule.") + illegalAccessException.getMessage()));
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getCause() instanceof PendingException && string.equals(LOGIN_METHOD)) {
                        throw (PendingException)invocationTargetException.getCause();
                    }
                    if (invocationTargetException.getCause() instanceof LoginException) {
                        object2 = (LoginException)invocationTargetException.getCause();
                    } else if (invocationTargetException.getCause() instanceof SecurityException) {
                        object2 = new LoginException("Security Exception");
                        ((Throwable)object2).initCause(new SecurityException());
                        if (debug != null) {
                            debug.println("original security exception with detail msg replaced by new exception with empty detail msg");
                            debug.println("original security exception: " + invocationTargetException.getCause().toString());
                        }
                    } else {
                        object = new StringWriter();
                        invocationTargetException.getCause().printStackTrace(new PrintWriter((Writer)object));
                        ((StringWriter)object).flush();
                        object2 = new LoginException(((StringWriter)object).toString());
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(string + " REQUISITE failure");
                        }
                        if (string.equals(ABORT_METHOD) || string.equals(LOGOUT_METHOD)) {
                            if (this.firstRequiredError == null) {
                                this.firstRequiredError = object2;
                            }
                        } else {
                            this.throwException(this.firstRequiredError, (LoginException)object2);
                        }
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(string + " REQUIRED failure");
                        }
                        if (this.firstRequiredError == null) {
                            this.firstRequiredError = object2;
                        }
                    }
                    if (debug != null) {
                        debug.println(string + " OPTIONAL failure");
                    }
                    if (this.firstError != null) break block38;
                    this.firstError = object2;
                }
            }
            ++n;
            ++this.moduleIndex;
        }
        if (this.firstRequiredError != null) {
            this.throwException(this.firstRequiredError, null);
        } else if (!this.success && this.firstError != null) {
            this.throwException(this.firstError, null);
        } else if (!this.success) {
            this.throwException(new LoginException(ResourcesMgr.getString("Login.Failure.all.modules.ignored")), null);
        } else {
            this.clearState();
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry appConfigurationEntry, Object object) {
            this.entry = appConfigurationEntry;
            this.module = object;
        }
    }

    private static class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext accessControlContext, CallbackHandler callbackHandler) {
            this.acc = accessControlContext;
            this.ch = callbackHandler;
        }

        @Override
        public void handle(final Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, UnsupportedCallbackException {
                        SecureCallbackHandler.this.ch.handle(callbackArray);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (UnsupportedCallbackException)privilegedActionException.getException();
            }
        }
    }
}

