/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.util;

import de.xam.datafiles.datamap.IDataMap;
import de.xam.datafiles.util.DataFiles;
import de.xam.texthtml.text.TextTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.conf.escape.Escaping;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class StringCodec {
    private static final Logger log = LoggerFactory.getLogger(StringCodec.class);
    private static final char MARKER_STRING = '\"';
    private static final char MARKER_NUMBER = '*';
    private static final char COMMA = ',';
    private static final char SET_START = '(';
    private static final char SET_END = ')';
    private static final char LIST_START = '[';
    private static final char LIST_END = ']';
    private static final char MAP_START = '{';
    private static final char MAP_END = '}';
    private static final char MAP_KEYVALUE_SEP = '=';

    public static String toValueString(Boolean value) {
        assert (value != null);
        return value.toString();
    }

    public static StringBuilder toValueString(Long value) {
        assert (value != null);
        StringBuilder b = new StringBuilder();
        b.append('*');
        b.append(value.toString());
        return b;
    }

    public static StringBuilder toValueString(String value) {
        assert (value != null);
        return StringCodec.addStringMarker(value);
    }

    public static StringBuilder toValueString(Set<String> value) {
        assert (value != null);
        StringBuilder b = new StringBuilder();
        b.append('(');
        b.append((CharSequence)TextTool.join(value, (char)',', (boolean)true));
        b.append(')');
        return b;
    }

    public static StringBuilder toValueString(List<String> value) {
        assert (value != null);
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append((CharSequence)TextTool.join(value, (char)',', (boolean)true));
        b.append(']');
        return b;
    }

    public static StringBuilder toValueString(Map<String, String> value) {
        assert (value != null);
        ArrayList<StringBuilder> keyvalue = new ArrayList<StringBuilder>();
        for (Map.Entry<String, String> e : value.entrySet()) {
            StringBuilder s = new StringBuilder();
            s.append(StringCodec.toDoubleQuotedString(e.getKey()));
            s.append('=');
            s.append(StringCodec.toDoubleQuotedString(e.getValue()));
            keyvalue.add(s);
        }
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append((CharSequence)TextTool.joinStringBuilder(keyvalue, (char)','));
        b.append('}');
        return b;
    }

    public static StringBuilder toValueStringFromObject(Object valueObject) {
        if (valueObject == null) {
            return null;
        }
        IDataMap.Type type = DataFiles.getValueType(valueObject);
        switch (type) {
            case Boolean: {
                return new StringBuilder(StringCodec.toValueString((Boolean)valueObject));
            }
            case Long: {
                return StringCodec.toValueString((Long)valueObject);
            }
            case String: {
                return StringCodec.toValueString((String)valueObject);
            }
            case StringSet: {
                return StringCodec.toValueString((Set)valueObject);
            }
            case StringList: {
                return StringCodec.toValueString((List)valueObject);
            }
            case StringMap: {
                return StringCodec.toValueString((Map)valueObject);
            }
        }
        throw new AssertionError();
    }

    public static Set<String> toStringSet(String valueString) {
        String s = valueString.trim();
        if (!s.startsWith("(")) {
            throw new IllegalArgumentException("valueString does not start with '('");
        }
        if ((s = s.substring(1)).endsWith(")")) {
            s = s.substring(0, s.length() - 1);
        }
        List<String> parts = StringCodec.splitAtCommaWhileRespectingQuotes(s);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String part : parts) {
            set.add(part);
        }
        return set;
    }

    public static List<String> splitAtCommaWhileRespectingQuotes(String s) throws ParseException {
        if (s.length() == 0) {
            return Collections.emptyList();
        }
        ParseState parseState = new ParseState();
        int i = 0;
        boolean quoted = false;
        boolean escaped = false;
        block9: while (i < s.length()) {
            int codePoint = s.codePointAt(i);
            if (quoted) {
                if (escaped) {
                    i += StringCodec.appendUnescaped(s, i, parseState, codePoint);
                    escaped = false;
                    continue;
                }
                switch (codePoint) {
                    case 34: {
                        quoted = false;
                        parseState.inToken = false;
                        ++i;
                        continue block9;
                    }
                    case 92: {
                        escaped = true;
                        ++i;
                        continue block9;
                    }
                }
                i += parseState.appendCodePoint(codePoint);
                continue;
            }
            if (escaped) {
                i += StringCodec.appendUnescaped(s, i, parseState, codePoint);
                escaped = false;
                if (parseState.currentToken.length() <= 0) continue;
                parseState.inToken = true;
                continue;
            }
            switch (codePoint) {
                case 34: {
                    quoted = true;
                    parseState.inToken = true;
                    ++i;
                    continue block9;
                }
                case 92: {
                    escaped = true;
                    ++i;
                    continue block9;
                }
                case 44: {
                    parseState.inToken = false;
                    parseState.fireToken();
                    ++i;
                    continue block9;
                }
            }
            if (TextTool.isWhitespace((int)codePoint)) {
                if (parseState.isInToken()) {
                    i += parseState.appendPreliminaryCodepoint(codePoint);
                    continue;
                }
                ++i;
                continue;
            }
            parseState.inToken = true;
            i += parseState.appendCodePoint(codePoint);
        }
        if (escaped) {
            parseState.appendCodePoint(92);
        }
        parseState.fireToken();
        return parseState.parts;
    }

    public static int appendUnescaped(String source, int index, ParseState parseState, int codePoint) {
        switch (codePoint) {
            case 92: {
                parseState.appendCodePoint(92);
                parseState.inToken = true;
                return 1;
            }
            case 34: {
                parseState.appendCodePoint(34);
                parseState.inToken = true;
                return 1;
            }
            case 110: {
                parseState.appendPreliminaryCodepoint(10);
                parseState.inToken = true;
                return 1;
            }
            case 116: {
                parseState.appendPreliminaryCodepoint(9);
                parseState.inToken = true;
                return 1;
            }
            case 114: {
                parseState.appendPreliminaryCodepoint(13);
                parseState.inToken = true;
                return 1;
            }
            case 117: {
                parseState.commitPreliminary();
                int parsed = Escaping.materializeUnicode((String)source, (int)(index + 1), (StringBuilder)parseState.currentToken);
                parseState.inToken = true;
                if (parsed <= 0) break;
                return 1 + parsed;
            }
        }
        parseState.appendCodePoint(92);
        parseState.appendCodePoint(codePoint);
        parseState.inToken = true;
        return 1;
    }

    public static List<String> toStringList(String valueString) {
        String s = valueString.trim();
        if (!s.startsWith("[")) {
            throw new IllegalArgumentException("valueString does not start with '['");
        }
        if ((s = s.substring(1)).endsWith("]")) {
            s = s.substring(0, s.length() - 1);
        }
        List<String> parts = StringCodec.splitAtCommaWhileRespectingQuotes(s);
        ArrayList<String> list = new ArrayList<String>();
        for (String part : parts) {
            list.add(TextTool.materializeEscapes((String)part));
        }
        return list;
    }

    public static Map<String, String> toStringMap(String valueString) {
        String[] keyvaluepairs;
        String s = valueString.trim();
        if (!s.startsWith("{")) {
            throw new IllegalArgumentException("valueString does not start with '{'");
        }
        if ((s = s.substring(1)).endsWith("}")) {
            s = s.substring(0, s.length() - 1);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String keyvaluepair : keyvaluepairs = TextTool.split((String)s, (String)", ", (boolean)false)) {
            log.trace("parsing keyvalue pair '" + keyvaluepair + "'");
            String[] key_value = TextTool.split((String)keyvaluepair, (String)"=:", (boolean)true);
            assert (key_value.length == 2) : key_value.length + " == '" + keyvaluepair + "'";
            map.put(key_value[0], TextTool.materializeEscapes((String)key_value[1]));
        }
        return map;
    }

    public static void dump(Map<String, String> map) {
        System.out.println("{");
        for (Map.Entry<String, String> e : map.entrySet()) {
            System.out.println("  '" + e.getKey() + "' = '" + e.getValue() + "',");
        }
        System.out.println("}");
    }

    public static void main(String[] args) {
        log.setLevel(Logger.Level.Trace);
        System.out.println(Arrays.asList(TextTool.split((String)"a=b,  XXX='${artifactId}'", (String)", ", (boolean)false)));
        StringCodec.dump(StringCodec.toStringMap("{artifactId=datafiles, simulate=true} "));
        StringCodec.dump(StringCodec.toStringMap("{a=b, XXX='${artifactId}' }"));
        String vs = StringCodec.toValueString("[foo]bar").toString();
        Object o = StringCodec.toObjectFromValueString(vs);
        assert (o instanceof String);
        StringCodec.printUsage();
    }

    public static Object toObjectFromValueString(String valueString) {
        if (valueString == null) {
            return null;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return "";
        }
        if (s.equals("true") || s.equals("false")) {
            return Boolean.parseBoolean(s);
        }
        int first = s.codePointAt(0);
        switch (first) {
            case 42: {
                String numberString = s.substring(1);
                return Long.parseLong(numberString);
            }
            case 40: {
                return StringCodec.toStringSet(valueString);
            }
            case 91: {
                return StringCodec.toStringList(valueString);
            }
            case 123: {
                return StringCodec.toStringMap(valueString);
            }
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            String escapesApplied = TextTool.materializeEscapes((String)s);
            return StringCodec.removeStringMarker(escapesApplied);
        }
    }

    private static String removeStringMarker(String escaped) {
        assert (escaped != null);
        if (escaped.length() < 2) {
            return escaped;
        }
        if (escaped.codePointAt(0) == 34) {
            return escaped.substring(1);
        }
        return escaped;
    }

    private static StringBuilder addStringMarker(String raw) {
        int first;
        assert (raw != null);
        StringBuilder b = new StringBuilder();
        if (raw.length() > 0 && ((first = raw.codePointAt(0)) == 34 || first == 42 || first == 40 || first == 91 || first == 123 || first == 48 || first == 49 || first == 50 || first == 51 || first == 52 || first == 53 || first == 54 || first == 55 || first == 56 || first == 57 || raw.equals("true") || raw.equals("false"))) {
            b.append('\"');
        }
        b.append(raw);
        return b;
    }

    public static void printUsage() {
        System.out.println("Characters needing escaping: (as regex character class syntax) [0-9\"*([{]");
    }

    public static String toDoubleQuotedString(String s) {
        String result = s;
        result = result.replace("\\", "\\\\");
        result = result.replace("\"", "\\\"");
        return "\"" + result + "\"";
    }

    public static String toReplacementStringFromObject(Object vo) {
        return vo.toString();
    }

    public static class ParseException
    extends RuntimeException {
    }

    static class ParseState {
        StringBuilder currentToken = new StringBuilder();
        StringBuilder preliminary = new StringBuilder();
        List<String> parts = new ArrayList<String>();
        boolean inToken = false;

        ParseState() {
        }

        public void fireToken() {
            if (this.currentToken.length() > 0) {
                this.parts.add(this.currentToken.toString());
            }
            this.currentToken.setLength(0);
            this.preliminary.setLength(0);
        }

        public int appendCodePoint(int codePoint) {
            this.commitPreliminary();
            this.currentToken.appendCodePoint(codePoint);
            return Character.charCount(codePoint);
        }

        public int appendPreliminaryCodepoint(int codePoint) {
            this.preliminary.appendCodePoint(codePoint);
            return Character.charCount(codePoint);
        }

        public void commitPreliminary() {
            if (this.preliminary.length() > 0) {
                this.currentToken.append(this.preliminary.toString());
                this.preliminary.setLength(0);
            }
        }

        public boolean isInToken() {
            return this.inToken;
        }
    }
}

