/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.store;

import de.xam.datafiles.store.IDataMapStore;
import java.util.Collection;
import java.util.HashSet;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;

public class CsvStore
implements IDataMapStore {
    private final String columnName;
    private final CsvTable table;

    public CsvStore(String columnName) {
        this.columnName = columnName;
        this.table = new CsvTable();
    }

    @Override
    public Object getValue(String key) {
        Row row = this.table.getOrCreateRow(key, false);
        if (row == null) {
            return null;
        }
        return row.getValue(this.columnName);
    }

    @Override
    public void setValue(String key, Object value) {
        Row row = this.table.getOrCreateRow(key, true);
        row.setValue(this.columnName, (String)value, false);
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> rowKeys = new HashSet<String>();
        for (Row row : this.table) {
            rowKeys.add(row.getKey());
        }
        return rowKeys;
    }

    public CsvTable getTable() {
        return this.table;
    }
}

