/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.datamap;

import de.xam.datafiles.datamap.IDataMap;
import de.xam.datafiles.store.DataMapStoreTools;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.store.MemoryDataMapStore;
import de.xam.datafiles.util.DataFiles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemoryDataMap
implements IDataMap {
    private final IDataMapStore dms;

    public MemoryDataMap() {
        this(new MemoryDataMapStore());
    }

    public MemoryDataMap(IDataMapStore dms) {
        this.dms = dms;
    }

    @Override
    public Boolean getBoolean(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        assert (DataFiles.getValueType(o) == IDataMap.Type.Boolean);
        return (Boolean)o;
    }

    @Override
    public Collection<String> getKeys() {
        return this.dms.getKeys();
    }

    @Override
    public Long getLong(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        assert (DataFiles.getValueType(o) == IDataMap.Type.Long);
        return (Long)o;
    }

    @Override
    public IDataMapStore getStore() {
        return this.dms;
    }

    @Override
    public String getString(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        if (DataFiles.getValueType(o) != IDataMap.Type.String) {
            throw new IllegalStateException("Type was " + (Object)((Object)DataFiles.getValueType(o)) + " for key " + key);
        }
        return (String)o;
    }

    @Override
    public List<String> getStringList(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        assert (DataFiles.getValueType(o) == IDataMap.Type.StringList);
        return (List)o;
    }

    @Override
    public Map<String, String> getStringMap(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        assert (DataFiles.getValueType(o) == IDataMap.Type.StringMap);
        return (Map)o;
    }

    @Override
    public Set<String> getStringSet(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        assert (DataFiles.getValueType(o) == IDataMap.Type.StringSet);
        return (Set)o;
    }

    @Override
    public IDataMap.Type getType(String key) {
        assert (key != null);
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        return DataFiles.getValueType(o);
    }

    @Override
    public Object getValue(String key) {
        assert (key != null);
        Object o = this.dms.getValue(key);
        if (o instanceof String) {
            return this.interpolate((String)o);
        }
        return o;
    }

    @Override
    public boolean hasValue(String key) {
        return this.dms.getValue(key) != null;
    }

    @Override
    public String interpolate(String raw) {
        return DataMapStoreTools.interpolate(raw, this.dms);
    }

    @Override
    public String searchAndReplace(String raw) {
        return DataMapStoreTools.searchAndReplace(raw, this.dms);
    }

    @Override
    public void setBoolean(String key, boolean b) {
        this.setValue(key, b);
    }

    @Override
    public void setLong(String key, long l) {
        this.setValue(key, l);
    }

    @Override
    public void setString(String key, String value) {
        this.setValue(key, value);
    }

    @Override
    public void setStringList(String key, List<String> value) {
        this.setValue(key, value);
    }

    @Override
    public void setStringMap(String key, Map<String, String> value) {
        this.setValue(key, value);
    }

    @Override
    public void setStringSet(String key, Set<String> value) {
        this.setValue(key, value);
    }

    @Override
    public void setValue(String key, Object value) {
        this.dms.setValue(key, value);
    }

    public String toString() {
        return DataMapStoreTools.dump(this.dms);
    }
}

