/*
 * Decompiled with CFR 0.152.
 */
package de.xam.vocabulary;

import de.xam.vocabulary.VocabularyTerm;
import java.util.HashSet;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Vocabulary {
    public static String PREFIX_VOCABULARY = "vocabulary";
    private static final Logger log = LoggerFactory.getLogger(Vocabulary.class);
    public static final String NAMESPACE_SEP = "-";
    private final String namespace;
    private final Set<VocabularyTerm> terms = new HashSet<VocabularyTerm>();
    private Class<?> vocabularyConstantsClass;

    public Vocabulary(String namespace) {
        this.namespace = namespace;
    }

    public boolean contains(XId id) {
        if (this.isMainVocabulary()) {
            return true;
        }
        return id.toString().startsWith(this.getNamespace());
    }

    public boolean containsStatically(XId id) {
        for (VocabularyTerm term : this.terms) {
            if (!term.id().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public void dump() {
        for (VocabularyTerm term : this.terms) {
            log.info("" + term);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public XId id() {
        return Base.toId((String)(PREFIX_VOCABULARY + NAMESPACE_SEP + (this.isMainVocabulary() ? "main" : this.getNamespace())));
    }

    public boolean isMainVocabulary() {
        return this.getNamespace() == null;
    }

    public Set<VocabularyTerm> terms() {
        return this.terms;
    }

    public void setConstantsClass(Class<?> vocabularyConstantsClass) {
        this.vocabularyConstantsClass = vocabularyConstantsClass;
    }

    public Class<?> getConstantsClass() {
        return this.vocabularyConstantsClass;
    }

    public VocabularyTerm addTerm(VocabularyTerm term) {
        this.terms.add(term);
        return term;
    }

    public VocabularyTerm createTerm(String idString) {
        VocabularyTerm term = new VocabularyTerm(null, null, idString);
        return this.addTerm(term);
    }
}

