/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared.time;

import de.xam.p13n.shared.time.MiniDateTime;
import java.sql.Date;

public class MiniLocalDate {
    private transient Date date;
    private final long millis;

    public MiniLocalDate(int year, int monthOfYear, int dayOfMonth) {
        Date date;
        this.date = date = new Date(year - 1900, monthOfYear - 1, dayOfMonth);
        this.millis = date.getTime();
    }

    public MiniLocalDate(long millis) {
        this.millis = millis;
    }

    public boolean equals(Object other) {
        return other instanceof MiniLocalDate && ((MiniLocalDate)other).millis == this.millis;
    }

    public int getDayOfMonth() {
        this.lazyInitDate();
        return this.date.getDate();
    }

    public long getMillis() {
        return this.millis;
    }

    public int getMonthOfYear() {
        this.lazyInitDate();
        return this.date.getMonth() + 1;
    }

    public int getYear() {
        this.lazyInitDate();
        return this.date.getYear() + 1900;
    }

    public int hashCode() {
        return new Long(this.millis).hashCode();
    }

    private void lazyInitDate() {
        if (this.date == null) {
            this.date = new Date(this.millis);
        }
    }

    public MiniDateTime toDateTimeAtStartOfDay() {
        return new MiniDateTime(this.getMillis());
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonthOfYear() + "-" + this.getDayOfMonth();
    }
}

