/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.time.TimeProvider;
import org.joda.time.DateTimeZone;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;

public class ConfParamsP13n
implements IConfigProvider {
    @ConfType(value=boolean.class)
    @ConfDoc(value="If true, we run in production and skip a number of slow internal checks, but do run more security things.")
    public static final String CACHE_BUNDLES = "p13n-cacheBundles";
    @ConfType(value=Cache.class)
    @ConfDoc(value="runtime p13n cache object")
    public static final String INSTANCE_CACHE = "p13n-instanceCache";
    @ConfType(value=Personalisation.class)
    @ConfDoc(value="Personalisation")
    public static final String P13N = "p13n";

    private static final Personalisation createDefaultP13n() {
        DateTimeZone berlin = DateTimeZone.forID((String)"Europe/Berlin");
        long offsetMillis = berlin.getOffset(TimeProvider.getCurrentTimeInMillis());
        int offsetHours = (int)(offsetMillis / 3600000L);
        return new Personalisation(MiniLocale.De_DE, offsetHours);
    }

    public void configureDefaults(IConfig conf) {
        conf.setDefault(P13N, (Object)ConfParamsP13n.createDefaultP13n(), true);
        conf.setDefault(CACHE_BUNDLES, (Object)true, true);
        Cache instanceCache = CacheBuilder.newBuilder().build();
        conf.setInstance(INSTANCE_CACHE, (Object)instanceCache);
    }
}

