/*
 * Decompiled with CFR 0.152.
 */
package de.xam.json;

import de.xam.json.JsonCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xydra.core.serialize.json.JSONException;

public class JON {
    private JsonType fixedType = null;
    protected List<String> keys = new ArrayList<String>();
    protected JON last = this;
    protected Map<String, JON> map = new HashMap<String, JON>();
    protected JON parent;
    protected List<Object> values = new ArrayList<Object>();

    public static void addCssClasses(JON jon, String path, String ... classNames) {
        JON sub = jon.getOrCreateChildByPath(path);
        String existingString = (String)JON.getSingleValue(sub);
        if (existingString == null) {
            String classNameString = JON.cssClasses(classNames).toString();
            if (classNameString.length() > 0) {
                sub.getValues().add(classNameString);
            }
        } else {
            assert (existingString.length() > 0);
            String[] existingClassNames = existingString.split(" ");
            TreeSet<String> allClassNames = new TreeSet<String>();
            allClassNames.addAll(Arrays.asList(existingClassNames));
            allClassNames.addAll(Arrays.asList(classNames));
            String allCss = JON.cssClasses(allClassNames.toArray(new String[0])).toString();
            sub.values.add(allCss);
        }
    }

    private static void appendAsJson(StringBuilder b, Object o, int depth, boolean compact) {
        if (o == null) {
            b.append("null");
        } else if (o instanceof Boolean) {
            b.append(o.toString());
        } else if (o instanceof Number) {
            try {
                b.append(JsonCodec.numberToString((Number)o));
            }
            catch (JSONException e) {
                throw new RuntimeException("Error", e);
            }
        } else if (o instanceof String) {
            b.append(JsonCodec.quote((String)o));
        } else {
            assert (o instanceof JON);
            JON jon = (JON)o;
            jon.appendToJson(b, depth, compact);
        }
    }

    private static void appendAsJsonArray(StringBuilder b, List<Object> values, int depth, boolean compact) {
        b.append("[");
        for (int i = 0; i < values.size(); ++i) {
            Object value;
            if (i > 0) {
                b.append(", ");
            }
            if ((value = values.get(i)) instanceof JON && ((JON)value).hasChildren()) {
                b.append("\n");
                JON.indent(b, depth + 1);
            }
            JON.appendAsJson(b, value, depth, compact);
        }
        b.append("]");
    }

    private static void appendAsJsonKey(StringBuilder b, String key, int depth, boolean compact) {
        b.append(JsonCodec.quote(key) + ":");
    }

    private static void appendAsJsonObject(StringBuilder b, JON jon, int depth, boolean compact) {
        b.append("{ ");
        boolean requireComma = false;
        if (!jon.values.isEmpty()) {
            if (jon.values.size() == 1) {
                JON.appendAsJsonKey(b, "_value", depth, compact);
                JON.appendAsJson(b, jon.values.get(0), depth, compact);
            } else {
                JON.appendAsJsonKey(b, "_values", depth, compact);
                JON.appendAsJsonArray(b, jon.values, depth + 1, compact);
            }
            requireComma = true;
        }
        for (int k = 0; k < jon.keys.size(); ++k) {
            String key = jon.keys.get(k);
            JON sub = jon.map.get(key);
            if (sub.isEmpty() && sub.fixedType == JsonType.EmptyIsHidden) continue;
            if (requireComma) {
                b.append(", ");
            }
            requireComma = false;
            if (k > 0 && sub.hasChildren()) {
                b.append("\n");
                JON.indent(b, depth + 1);
            }
            if (k > 0 && !compact) {
                b.append("\n");
                JON.indent(b, depth + 2);
            }
            JON.appendAsJsonKey(b, key, depth, compact);
            if (sub.isEmpty()) {
                if (sub.fixedType == null) {
                    b.append("null /* empty */");
                    continue;
                }
                switch (sub.fixedType) {
                    case Array: {
                        b.append("[]");
                        break;
                    }
                    case Object: {
                        b.append("{}");
                        break;
                    }
                    case EmptyIsNull: {
                        b.append("null");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                requireComma = true;
                continue;
            }
            sub.appendToJson(b, depth + 1, compact);
            if (k + 1 >= jon.keys.size()) continue;
            requireComma = true;
        }
        b.append("}");
    }

    private static void copyMap(JON source, JON target) {
        for (String key : source.keys) {
            JON sourceChild = source.get(key);
            JON targetChild = sourceChild.copy();
            target.putJON(key, targetChild);
        }
    }

    private static void copyValues(JON source, JON target) {
        for (Object sourceValue : source.values) {
            if (sourceValue instanceof JON) {
                JON targetValue = ((JON)sourceValue).copy();
                target.values.add(targetValue);
                continue;
            }
            target.values.add(sourceValue);
        }
    }

    public static JON create() {
        return new JON(null);
    }

    public static StringBuilder cssClasses(String ... className) {
        StringBuilder b = new StringBuilder();
        if (className != null) {
            for (int i = 0; i < className.length; ++i) {
                b.append(className[i]);
                if (i <= 0) continue;
                b.append(" ");
            }
        }
        return b;
    }

    private static Object getSingleValue(JON jon) throws IllegalStateException {
        if (jon == null) {
            return null;
        }
        if (jon.values.isEmpty()) {
            return null;
        }
        if (jon.values.size() > 1) {
            throw new IllegalStateException("Contain more than 1 value");
        }
        return jon.values.get(0);
    }

    private static void indent(StringBuilder b, int depth) {
        for (int i = 0; i < depth; ++i) {
            b.append("  ");
        }
    }

    private static Boolean toBoolean(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof JON) {
            return (Boolean)JON.getSingleValue((JON)o);
        }
        return (Boolean)o;
    }

    private static Double toDouble(Number number) {
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    private static Integer toInt(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    private static Number toNumber(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof JON) {
            return (Number)JON.getSingleValue((JON)o);
        }
        return (Number)o;
    }

    private static String toString(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof JON) {
            return (String)JON.getSingleValue((JON)o);
        }
        assert (o instanceof String) : "o=" + o + " (" + o.getClass() + ")";
        return (String)o;
    }

    protected JON(JON parent) {
        this.parent = parent;
    }

    public JON add(JON jon) {
        this.values.add(jon);
        return this;
    }

    public JON add(String string) {
        return this.addToLast(string);
    }

    private JON addToLast(Object o) {
        this.last.add(o);
        return this;
    }

    private void add(Object value) {
        assert (value != null);
        if (value instanceof JON) {
            JON jonValue = (JON)value;
            if (!jonValue.hasChildren()) {
                this.values.addAll(jonValue.values);
                if (this.fixedType == null) {
                    this.fixedType = jonValue.fixedType;
                }
            } else {
                this.values.add(value);
            }
        } else {
            this.values.add(value);
        }
    }

    public JON add(Collection<?> coll) {
        for (Object o : coll) {
            this.last.add(o);
        }
        return this;
    }

    public JON and() {
        return this.getRoot();
    }

    public JON appendString(String path, String separator, String appended) throws IllegalStateException, ClassCastException {
        JON jon = this.getOrCreateChildByPath(path);
        Object o = JON.getSingleValue(jon);
        if (o == null) {
            jon.setSingleValue(appended);
        } else {
            jon.setSingleValue(o.toString() + separator + appended);
        }
        return this;
    }

    public void appendToJson(StringBuilder b, int depth, boolean compact) {
        if (this.isEmpty()) {
            return;
        }
        if (this.isArray() || this.fixedType == JsonType.Array) {
            JON.appendAsJsonArray(b, this.values, depth, compact);
        } else if (this.isSingleValue()) {
            JON.appendAsJson(b, JON.getSingleValue(this), depth, compact);
        } else {
            JON.appendAsJsonObject(b, this, depth, compact);
        }
    }

    private JON copy() {
        JON copy = new JON(this.parent);
        JON.copyValues(this, copy);
        JON.copyMap(this, copy);
        if (this.fixedType != null) {
            copy.fixedType = this.fixedType;
        }
        return copy;
    }

    public JON createChildValue() {
        JON jon = new JON(this);
        this.values.add(jon);
        return jon;
    }

    public JON get(String path) {
        return this.getJonByPath(path);
    }

    public Boolean getBoolean(String path) throws IllegalStateException, ClassCastException {
        JON jon = this.getJonByPath(path);
        Object o = JON.getSingleValue(jon);
        return JON.toBoolean(o);
    }

    public Double getDouble(String path) throws IllegalStateException, ClassCastException {
        Number number = this.getNumber(path);
        return JON.toDouble(number);
    }

    public Integer getInt(String path) throws IllegalStateException, ClassCastException {
        Number number = this.getNumber(path);
        return JON.toInt(number);
    }

    private JON getJonByKey(String key) {
        return this.map.get(key);
    }

    private JON getJonByPath(String path) {
        if (path.contains(".")) {
            int i = path.indexOf(46);
            assert (i + 1 < path.length());
            String prefix = path.substring(0, i);
            String remainder = path.substring(i + 1);
            JON jon = this.getJonByKey(prefix);
            if (jon == null) {
                return null;
            }
            return jon.getJonByPath(remainder);
        }
        return this.getJonByKey(path);
    }

    private JON getOrCreateChildByPath(String path) {
        if (path.contains(".")) {
            int i = path.indexOf(46);
            assert (i + 1 < path.length());
            String prefix = path.substring(0, i);
            String remainder = path.substring(i + 1);
            JON jon = this.getOrCreateChildByKey(prefix);
            return jon.getOrCreateChildByPath(remainder);
        }
        return this.getOrCreateChildByKey(path);
    }

    private JON getOrCreateChildByKey(String key) {
        JON jon;
        if (!this.map.containsKey(key)) {
            this.keys.add(key);
            jon = new JON(this);
            this.map.put(key, jon);
        } else {
            jon = this.map.get(key);
        }
        return jon;
    }

    public Set<Map.Entry<String, JON>> getKeyValueEntrySet() {
        return this.map.entrySet();
    }

    public Number getNumber(String path) throws IllegalStateException, ClassCastException {
        JON jon = this.getJonByPath(path);
        Object o = JON.getSingleValue(jon);
        return JON.toNumber(o);
    }

    private JON getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public String getString(String path) throws IllegalStateException, ClassCastException {
        JON jon = this.getJonByPath(path);
        Object o = JON.getSingleValue(jon);
        return JON.toString(o);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public JON goTo(String path) {
        JON jon = this.getOrCreateChildByPath(path);
        return jon;
    }

    public JON goUp() {
        return this.parent;
    }

    private boolean hasChildren() {
        return this.values.size() > 1 || !this.map.isEmpty();
    }

    private boolean isArray() {
        return this.map.isEmpty() && this.values.size() > 1;
    }

    public boolean isArrayOrSingleValue() {
        return this.isSingleValue() || this.isArray();
    }

    public boolean isEmpty() {
        return this.map.isEmpty() && this.values.isEmpty();
    }

    public boolean isSingleValue() {
        return this.map.isEmpty() && this.values.size() <= 1;
    }

    public boolean isTrue(String path) throws IllegalStateException {
        JON jon = this.getJonByPath(path);
        if (jon == null) {
            return false;
        }
        Object v = JON.getSingleValue(jon);
        return v instanceof Boolean && (Boolean)v != false;
    }

    public void putAll(JON other) {
        JON.copyValues(other, this);
        JON.copyMap(other, this);
        if (other.fixedType != null) {
            this.fixedType = other.fixedType;
        }
    }

    public JON putBoolean(String path, Boolean ... bool) {
        return this.putObjects(path, false, bool);
    }

    public JON putInt(String path, Integer ... integers) {
        return this.putObjects(path, false, integers);
    }

    public JON putJON(String path, JON ... jon) {
        return this.putObjects(path, false, jon);
    }

    public JON putNumber(String path, Number ... number) {
        return this.putObjects(path, false, number);
    }

    private JON putObject(String path, Object value) {
        JON jon;
        assert (value != null);
        this.last = jon = this.getOrCreateChildByPath(path);
        jon.add(value);
        return this;
    }

    private JON putObjects(String path, boolean append, Object ... values) {
        JON jon = this.getOrCreateChildByPath(path);
        if (values != null) {
            if (!append && !jon.values.isEmpty()) {
                jon.values.clear();
            }
            for (Object o : values) {
                assert (o != null);
                jon.add(o);
            }
        }
        this.last = jon;
        return this;
    }

    public JON putString(String path, String ... string) {
        return this.putObjects(path, false, string);
    }

    public JON setTypeAsArray() {
        this.fixedType = JsonType.Array;
        return this;
    }

    public JON setEmptyIsHidden() {
        this.fixedType = JsonType.EmptyIsHidden;
        return this;
    }

    public JON setEmptyIsNull() {
        this.fixedType = JsonType.EmptyIsNull;
        return this;
    }

    public JON setTypeAsObject() {
        this.fixedType = JsonType.Object;
        return this;
    }

    private void setSingleValue(Object o) {
        this.values.clear();
        this.values.add(o);
    }

    public String toJson(boolean compact) {
        StringBuilder b = new StringBuilder();
        this.appendToJson(b, 0, compact);
        return b.toString();
    }

    public String toString() {
        return this.toJson(true);
    }

    static enum JsonType {
        Array,
        EmptyIsHidden,
        EmptyIsNull,
        Object;

    }
}

