/*
 * Decompiled with CFR 0.152.
 */
package nf.fr.eraasoft.pool.impl;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import nf.fr.eraasoft.pool.PoolException;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObject;
import nf.fr.eraasoft.pool.impl.AbstractPool;

public abstract class BlockingQueueObjectPool<T>
extends AbstractPool<T> {
    LinkedBlockingQueue<T> linkQueue;

    public BlockingQueueObjectPool(PoolableObject<T> poolableObject, PoolSettings<T> settings) {
        super(poolableObject, settings);
        this.queue = new LinkedBlockingQueue();
        this.linkQueue = (LinkedBlockingQueue)this.queue;
        try {
            this.init();
        }
        catch (PoolException e) {
            e.printStackTrace();
        }
    }

    @Override
    public T getObj() throws PoolException {
        if (this.queue.size() == 0 && this.totalSize.get() < this.settings.max()) {
            this.create();
        }
        T t = null;
        try {
            t = this.linkQueue.poll(this.settings.maxWait(), TimeUnit.SECONDS);
            this.poolableObject.activate(t);
        }
        catch (InterruptedException e) {
            throw new PoolException(e);
        }
        return t;
    }
}

