/*
 * Decompiled with CFR 0.152.
 */
package nf.fr.eraasoft.pool.impl;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import nf.fr.eraasoft.pool.ObjectPool;
import nf.fr.eraasoft.pool.PoolException;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.PoolableObject;
import nf.fr.eraasoft.pool.impl.Controlable;

public abstract class AbstractPool<T>
implements ObjectPool<T>,
Controlable {
    final PoolSettings<T> settings;
    final PoolableObject<T> poolableObject;
    Queue<T> queue;
    final AtomicInteger totalSize = new AtomicInteger(0);

    public AbstractPool(PoolableObject<T> poolableObject, PoolSettings<T> settings) {
        this.poolableObject = poolableObject;
        this.settings = settings;
    }

    protected void init() throws PoolException {
        for (int n = 0; n < this.settings.min(); ++n) {
            this.create();
        }
    }

    protected void create() throws PoolException {
        T t = this.poolableObject.make();
        this.totalSize.incrementAndGet();
        this.queue.add(t);
    }

    @Override
    public void returnObj(T t) {
        if (t == null) {
            return;
        }
        if (!this.settings.validateWhenReturn() || this.poolableObject.validate(t)) {
            this.poolableObject.passivate(t);
            this.queue.add(t);
        } else {
            this.destroyObject(t);
        }
    }

    private void destroyObject(T t) {
        this.poolableObject.destroy(t);
        this.totalSize.decrementAndGet();
    }

    @Override
    public int idles() {
        return this.queue.size();
    }

    @Override
    public void remove(int nbObjects) {
        T t;
        for (int n = 0; n < nbObjects && (t = this.queue.poll()) != null; ++n) {
            this.destroyObject(t);
        }
    }

    @Override
    public void clear() {
        while (this.queue.size() > 0) {
            T t = this.queue.poll();
            this.destroyObject(t);
        }
        this.totalSize.set(0);
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public int actives() {
        return this.totalSize.get() - this.queue.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int total = this.totalSize.get();
        b.append(this.getClass().getSimpleName());
        b.append(",  totalSize: ").append(total);
        b.append(", numActive: ").append(this.actives());
        b.append(", numIdle: ").append(this.idles());
        b.append(", max: ").append(this.settings.max());
        b.append(", queueSize: ").append(this.queue.size());
        return b.toString();
    }

    @Override
    public void validateIdles() {
        Object t2;
        ArrayList<T> listT = new ArrayList<T>(this.queue.size());
        int queueSise = this.queue.size();
        for (int n = 0; n < queueSise && (t2 = this.queue.poll()) != null; ++n) {
            if (this.poolableObject.validate(t2)) {
                listT.add(t2);
                continue;
            }
            this.destroyObject(t2);
        }
        for (Object t2 : listT) {
            this.queue.add(t2);
        }
        int objectToCreate = this.settings.min() - this.totalSize.get();
        for (int n = 0; n < objectToCreate; ++n) {
            try {
                this.create();
                continue;
            }
            catch (Exception e) {
                System.out.println("Create object error " + e.getClass().getSimpleName() + " " + e.getMessage());
            }
        }
    }
}

