/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.server;

import com.sonicmetrics.core.shared.util.SharedIndexedDay;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class IndexedDay
extends SharedIndexedDay {
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy'-'MM'-'dd");
    private static final SimpleDateFormat ISO_DATETIME_FORMAT = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss','SSS'Z'");

    protected static void assertAfterBigBang(long timeUtc, long bigBang) {
        if (timeUtc < bigBang) {
            throw new IllegalArgumentException("not a valid timeStamp - must be after " + IndexedDay.toIsoDateTimeString(bigBang) + ", was on " + IndexedDay.toIsoDateTimeString(timeUtc));
        }
    }

    public static String toUpperIsoDateString(int indexedDay, long bigBang) {
        return IndexedDay.toIsoDateString(IndexedDay.toUpperUtc(indexedDay, bigBang));
    }

    public static String toIsoDateString(int indexedDay, long bigBang) {
        return IndexedDay.toIsoDateString(IndexedDay.toUtc(indexedDay, bigBang));
    }

    public static String toIsoDateString(long utcTime) {
        return ISO_DATE_FORMAT.format(new Date(utcTime));
    }

    public static String toIsoDateTimeString(long utcTime) {
        return ISO_DATETIME_FORMAT.format(new Date(utcTime));
    }

    public static int parseIsoDateString(String isoDate, long bigBang) {
        try {
            String yearStr = isoDate.substring(0, 4);
            int year = Integer.parseInt(yearStr);
            String monthStr = isoDate.substring(5, 7);
            int month = Integer.parseInt(monthStr) - 1;
            String dayStr = isoDate.substring(8, 10);
            int day = Integer.parseInt(dayStr);
            GregorianCalendar gc = new GregorianCalendar();
            gc.set(year, month, day, 0, 0, 0);
            long timeInMillis = gc.getTimeInMillis();
            return IndexedDay.toIndexedDay(timeInMillis, bigBang);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse '" + isoDate + "'", e);
        }
    }
}

