/*
 * Decompiled with CFR 0.152.
 */
package de.xam.color;

import de.xam.color.ColorTool;
import de.xam.color.HSLColor;

public class RGBColor {
    private static final double OPAQUE = 1.0;
    private double alpha;
    private double r;
    private double g;
    private double b;

    public RGBColor(double r, double g, double b, double alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public RGBColor(int r, int g, int b) {
        this(r, g, b, 1.0);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBlue255() {
        return this.b;
    }

    public int getBlueInt() {
        return (int)Math.round(this.b);
    }

    public double getGreen255() {
        return this.g;
    }

    public int getGreenInt() {
        return (int)Math.round(this.g);
    }

    public double getRed255() {
        return this.r;
    }

    public int getRedInt() {
        return (int)Math.round(this.r);
    }

    public String toCssHex() {
        return "#" + RGBColor.toCssHex(this.getRedInt()) + RGBColor.toCssHex(this.getGreenInt()) + RGBColor.toCssHex(this.getBlueInt());
    }

    private static String toCssHex(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public String toString() {
        return "r=" + this.r + ",g=" + this.g + ",b=" + this.b + ",alpha=" + this.alpha + " CSS: " + this.toCssHex();
    }

    public double getRed1() {
        return this.getRed255() / 255.0;
    }

    public double getGreen1() {
        return this.getGreen255() / 255.0;
    }

    public double getBlue1() {
        return this.getBlue255() / 255.0;
    }

    public HSLColor toHSL() {
        return ColorTool.rgbToHsl(this);
    }

    public RGBColor setAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }
}

